/*
 * Decompiled with CFR 0.152.
 */
package iaik.iso.iso9796;

import iaik.asn1.structures.AlgorithmID;
import iaik.iso.iso9796.ISO9796P2S2S3ParameterSpec;
import iaik.iso.iso9796.ISO9796P2Signature;
import iaik.iso.iso9796.RawISO9796P2S2S3ParameterSpec;
import iaik.pkcs.pkcs1.MGF1;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public abstract class ISO9796P2S2S3Signature
extends ISO9796P2Signature {
    protected MaskGenerationAlgorithm mgfEngine_;
    int a;
    byte[] b;
    private int p;

    public static int calculateCapacity(int n2, int n3, int n4, boolean bl) {
        int n5 = n2 - n3 - n4 - (bl ? 16 : 8) - 2;
        if (n5 < 7) {
            throw new IllegalArgumentException("Invalid capacity (" + n5 + "). Must be >= 7!");
        }
        return n5;
    }

    public static int calculateCapacity(int n2, int n3, boolean bl) {
        throw new IllegalStateException("Method not supported. Use calculateCapacity(modLen, hashLen, saltLen, explicit)!");
    }

    protected ISO9796P2S2S3Signature(String string) {
        super(string);
        this.mgfEngine_ = new MGF1((AlgorithmID)AlgorithmID.sha1.clone(), this.hashEngine_);
        this.p = 0;
        this.a = 20;
    }

    protected ISO9796P2S2S3Signature(String string, int n2, byte by) {
        super(string, n2, by);
        this.p = 0;
        this.a = n2;
    }

    protected void engineUpdate(byte by) {
        this.j = null;
        if (this.hashEngine_ == null && this.o == null) {
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (this.i == null) {
            this.b();
        }
        if (this.o != null) {
            this.o.update(by);
        } else {
            ++this.l;
            if (this.k < this.i.length) {
                this.i[this.k++] = by;
            } else {
                this.hashEngine_.update(by);
            }
        }
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.j = null;
        if (this.hashEngine_ == null && this.o == null) {
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (this.i == null) {
            this.b();
        }
        if (this.o == null) {
            if (this.k < this.i.length) {
                int n4 = Math.min(this.i.length - this.k, n3);
                System.arraycopy(byArray, n2, this.i, this.k, n4);
                this.k += n4;
                int n5 = n3 - n4;
                if (n5 > 0) {
                    this.hashEngine_.update(byArray, n2 + n4, n5);
                }
            } else {
                this.hashEngine_.update(byArray, n2, n3);
            }
            this.l += n3;
        } else {
            this.o.update(byArray, n2, n3);
        }
    }

    int a() {
        return ISO9796P2S2S3Signature.calculateCapacity(this.h, this.d * 8, this.a * 8, this.f) - this.p;
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            byte[] byArray;
            if (!(algorithmParameterSpec instanceof ISO9796P2S2S3ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Parameters must be a ISO9796P2S2S3ParameterSpec!");
            }
            super.engineSetParameter(algorithmParameterSpec);
            ISO9796P2S2S3ParameterSpec iSO9796P2S2S3ParameterSpec = (ISO9796P2S2S3ParameterSpec)algorithmParameterSpec;
            MaskGenerationAlgorithm maskGenerationAlgorithm = iSO9796P2S2S3ParameterSpec.getMGFEngine();
            if (maskGenerationAlgorithm != null) {
                if (this.m && !this.mgfEngine_.getAlgorithm().equalsIgnoreCase(maskGenerationAlgorithm.getAlgorithm())) {
                    throw new InvalidAlgorithmParameterException("Invalid mgf engine parameter (" + maskGenerationAlgorithm.getAlgorithm() + "). Expected " + this.mgfEngine_.getAlgorithm() + ".");
                }
                this.mgfEngine_ = maskGenerationAlgorithm;
            }
            if ((byArray = iSO9796P2S2S3ParameterSpec.getSalt()) != null) {
                this.a = byArray.length;
            } else {
                int n2 = iSO9796P2S2S3ParameterSpec.getSaltLength();
                if (n2 > -1) {
                    this.a = n2;
                }
            }
            this.b = byArray;
            this.p = iSO9796P2S2S3ParameterSpec.getCMinus();
            if (algorithmParameterSpec instanceof RawISO9796P2S2S3ParameterSpec) {
                RawISO9796P2S2S3ParameterSpec rawISO9796P2S2S3ParameterSpec = (RawISO9796P2S2S3ParameterSpec)algorithmParameterSpec;
                this.a(rawISO9796P2S2S3ParameterSpec.getMr(), rawISO9796P2S2S3ParameterSpec.getMsgLen(), rawISO9796P2S2S3ParameterSpec.a());
            }
        }
    }

    protected void reset(BigInteger bigInteger) {
        super.reset(bigInteger);
        if (this.mgfEngine_ != null) {
            this.mgfEngine_.reset();
        }
    }

    protected byte[] engineSign() throws SignatureException {
        Object object;
        if (this.hashEngine_ == null) {
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (this.mgfEngine_ == null) {
            throw new NullPointerException("MGF engine must not be null!");
        }
        if (this.i == null) {
            this.b();
        }
        this.j = null;
        byte[] byArray = new byte[8];
        CryptoUtils.spreadIntsToBytes(new int[]{this.k * 8}, 0, byArray, 4, 1);
        byte[] byArray2 = this.b;
        if (byArray2 == null && this.a > 0) {
            byArray2 = new byte[this.a];
            object = this.getSecureRandom();
            ((SecureRandom)object).nextBytes(byArray2);
        }
        if (this.o != null) {
            object = this.o.digest();
            this.hashEngine_.reset();
        } else {
            object = this.hashEngine_.digest();
        }
        this.hashEngine_.update(byArray);
        if (this.k > 0) {
            this.hashEngine_.update(this.i, 0, this.k);
        }
        this.hashEngine_.update((byte[])object);
        byte[] byArray3 = this.a > 0 ? this.hashEngine_.digest(byArray2) : this.hashEngine_.digest();
        int n2 = byArray3.length;
        int n3 = (this.h + 7) / 8;
        byte[] byArray4 = new byte[n3];
        int n4 = n3 - 1;
        int n5 = 1;
        if (this.f) {
            byArray4[n4] = -52;
            byArray4[--n4] = this.e;
            n5 = 2;
        } else {
            byArray4[n4] = -68;
        }
        if (n3 < 1 + this.k + this.a + n2 + n5) {
            CryptoUtils.zeroBlock(byArray3);
            CryptoUtils.zeroBlock(byArray4);
            throw new SignatureException("Modulus too short!");
        }
        System.arraycopy(byArray3, 0, byArray4, n4 -= n2, n2);
        if (byArray2 != null && this.a > 0) {
            System.arraycopy(byArray2, 0, byArray4, n4 -= byArray2.length, this.a);
        }
        System.arraycopy(this.i, 0, byArray4, n4 -= this.k, this.k);
        byArray4[--n4] = 1;
        this.mgfEngine_.mask(byArray3, 0, n2, byArray4.length - n2 - n5, byArray4, 0);
        CryptoUtils.zeroBlock(byArray3);
        byArray4[0] = (byte)(byArray4[0] & 0x7F);
        byte[] byArray5 = this.a(byArray4);
        this.reset(null);
        CryptoUtils.zeroBlock(byArray4);
        return byArray5;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        int n2;
        int n3;
        Object object;
        this.j = null;
        if (this.mgfEngine_ == null) {
            throw new NullPointerException("Cannot verify signature. MGF engine must not be null!");
        }
        if (this.h == 0) {
            throw new IllegalStateException("Length of public parameter not set");
        }
        byte[] byArray2 = this.b(byArray);
        if (byArray2.length * 8 != this.h && (byArray2[0] & 0x80) != 0) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid signature. Sr not k-1 bits long.");
        }
        int n4 = byArray2.length - 1;
        int n5 = 1;
        if (byArray2[n4] == -52) {
            if (byArray2[--n4] != this.e) {
                object = this.b(byArray2[n5]);
                if (object == null) {
                    CryptoUtils.zeroBlock(byArray2);
                    throw new SignatureException("Invalid hash id. Expected " + Util.toString(this.e));
                }
                this.hashEngine_ = object;
            }
            n5 = 2;
        } else if (byArray2[n4] != -68) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid trailer byte. Expected 0xBC or 0xCC.");
        }
        if (this.hashEngine_ == null) {
            CryptoUtils.zeroBlock(byArray2);
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (this.o != null) {
            object = this.o.digest();
            this.hashEngine_.reset();
        } else {
            object = this.hashEngine_.digest();
        }
        int n6 = ((Object)object).length;
        if ((n4 -= n6) <= this.a + 2) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid formatted signature string!");
        }
        this.mgfEngine_.mask(byArray2, n4, n6, n4, byArray2, 0);
        byArray2[0] = (byte)(byArray2[0] & 0x7F);
        for (n3 = 0; n3 < n4 && byArray2[n3] == 0; ++n3) {
        }
        if (n3 == n4) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid padding!");
        }
        if (byArray2[n3] != 1) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid border byte. Expected 0x01!");
        }
        int n7 = n4 - this.a;
        if ((n2 = n7 - ++n3) < 0) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid padding!");
        }
        if (this.i != null && !CryptoUtils.secureEqualsBlock(byArray2, n3, this.i, 0, n2)) {
            CryptoUtils.zeroBlock(byArray2);
            throw new SignatureException("Invalid message recovery.");
        }
        this.j = new byte[n2];
        System.arraycopy(byArray2, n3, this.j, 0, n2);
        byte[] byArray3 = new byte[8];
        CryptoUtils.spreadIntsToBytes(new int[]{n2 * 8}, 0, byArray3, 4, 1);
        this.hashEngine_.update(byArray3);
        if (n2 > 0) {
            this.hashEngine_.update(this.j);
        }
        this.hashEngine_.update((byte[])object);
        if (this.a > 0) {
            this.hashEngine_.update(byArray2, n7, this.a);
        }
        byte[] byArray4 = this.hashEngine_.digest();
        boolean bl = CryptoUtils.secureEqualsBlock(byArray2, n4, byArray4, 0, n6);
        CryptoUtils.zeroBlock(byArray2);
        if (!bl) {
            CryptoUtils.zeroBlock(this.j);
            this.j = null;
        }
        this.reset(null);
        return bl;
    }
}

