/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SET;
import iaik.asn1.structures.AVA;
import iaik.utils.RFC2253NameParserException;
import iaik.utils.Util;
import java.util.Enumeration;
import java.util.Vector;

public class RDN
implements ASN1Type {
    protected Vector avas = new Vector(3);

    public RDN() {
    }

    public RDN(ObjectID objectID, Object object) {
        this();
        this.addAVA(new AVA(objectID, object), false);
    }

    public RDN(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
            AVA aVA = new AVA(aSN1Object.getComponentAt(i2));
            this.addAVA(aVA, false);
        }
    }

    public ASN1Object toASN1Object() {
        SET sET = new SET(true);
        Enumeration enumeration = this.avas.elements();
        while (enumeration.hasMoreElements()) {
            sET.addComponent(((AVA)enumeration.nextElement()).toASN1Object());
        }
        return sET;
    }

    public void addAVA(ObjectID objectID, Object object) {
        this.addAVA(new AVA(objectID, object));
    }

    public void addAVA(AVA aVA) {
        this.addAVA(aVA, true);
    }

    public void addAVA(AVA aVA, boolean bl) {
        boolean bl2 = true;
        if (bl) {
            ObjectID objectID = aVA.getType();
            int n2 = this.avas.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                AVA aVA2 = (AVA)this.avas.elementAt(i2);
                if (!aVA2.getType().equals(objectID)) continue;
                this.avas.setElementAt(aVA, i2);
                bl2 = false;
                break;
            }
        }
        if (bl2) {
            this.avas.addElement(aVA);
        }
    }

    public AVA getAVA(ObjectID objectID) {
        Enumeration enumeration = this.avas.elements();
        while (enumeration.hasMoreElements()) {
            AVA aVA = (AVA)enumeration.nextElement();
            if (!aVA.getType().equals(objectID)) continue;
            return aVA;
        }
        return null;
    }

    public AVA[] getAVAs(ObjectID objectID) {
        Vector<AVA> vector = new Vector<AVA>();
        Object[] objectArray = this.avas.elements();
        while (objectArray.hasMoreElements()) {
            AVA aVA = (AVA)objectArray.nextElement();
            if (!aVA.getType().equals(objectID)) continue;
            vector.addElement(aVA);
        }
        objectArray = new AVA[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public AVA getAVA() {
        return (AVA)this.avas.elementAt(0);
    }

    public Enumeration elements() {
        return this.avas.elements();
    }

    public AVA[] getAVAs() {
        Object[] objectArray = new AVA[this.avas.size()];
        this.avas.copyInto(objectArray);
        return objectArray;
    }

    public int hashCode() {
        int n2;
        int n3 = n2 = this.avas.size();
        Enumeration enumeration = this.avas.elements();
        while (enumeration.hasMoreElements()) {
            AVA aVA = (AVA)enumeration.nextElement();
            n3 = n3 << 7 | n3 >>> 25;
            n3 += aVA.hashCode();
        }
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RDN)) {
            return false;
        }
        RDN rDN = (RDN)object;
        int n2 = this.avas.size();
        if (n2 != rDN.avas.size()) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            AVA aVA = (AVA)this.avas.elementAt(i2);
            if (rDN.avas.contains(aVA)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.avas.elements();
        if (enumeration.hasMoreElements()) {
            stringBuffer.append(((AVA)enumeration.nextElement()).toString(bl));
        } else {
            return stringBuffer.toString();
        }
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("+" + ((AVA)enumeration.nextElement()).toString(bl));
        }
        String string = stringBuffer.toString();
        return string;
    }

    public String getRFC2253String() throws RFC2253NameParserException {
        return this.getRFC2253String(Util.getDefaultRFC2253StringEscaping());
    }

    public String getRFC2253String(boolean bl) throws RFC2253NameParserException {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.avas.elements();
        if (enumeration.hasMoreElements()) {
            stringBuffer.append(((AVA)enumeration.nextElement()).getRFC2253String(bl));
        } else {
            return stringBuffer.toString();
        }
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("+" + ((AVA)enumeration.nextElement()).getRFC2253String(bl));
        }
        return stringBuffer.toString();
    }
}

