/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.RDN;
import iaik.utils.InternalErrorException;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CRLException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class DistributionPoint {
    public static final int unused = 1;
    public static final int keyCompromise = 2;
    public static final int cACompromise = 4;
    public static final int affiliationChanged = 8;
    public static final int superseded = 16;
    public static final int cessationOfOperation = 32;
    public static final int certificateHold = 64;
    public static final int privilegeWithdrawn = 128;
    public static final int aACompromise = 256;
    private ASN1Type b;
    private int c = -1;
    private GeneralNames d;
    X509CRL a;
    private String e = "authorityRevocationList;binary,certificateRevocationList;binary";

    public DistributionPoint() {
    }

    public DistributionPoint(ASN1Type aSN1Type) throws IllegalArgumentException {
        this();
        this.setDistributionPointName(aSN1Type);
    }

    public DistributionPoint(String[] stringArray) {
        this();
        this.setDistributionPointNameURIs(stringArray);
    }

    public DistributionPoint(ASN1Object aSN1Object) throws CodingException {
        this();
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("No DistributionPoint!");
        }
        block5: for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
            CON_SPEC cON_SPEC = null;
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(i2);
            if (!aSN1Object2.isA(ASN.CON_SPEC)) {
                throw new CodingException("No DistributionPoint!");
            }
            int n2 = aSN1Object2.getAsnType().getTag();
            switch (n2) {
                case 0: {
                    ASN1Object aSN1Object3;
                    ASN1Object aSN1Object4 = (ASN1Object)aSN1Object2.getValue();
                    if (!aSN1Object4.isA(ASN.CON_SPEC)) {
                        throw new CodingException("No DistributionPoint!");
                    }
                    cON_SPEC = (CON_SPEC)aSN1Object4;
                    int n3 = cON_SPEC.getAsnType().getTag();
                    if (n3 == 0) {
                        if (cON_SPEC.countComponents() > 1) {
                            cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                        }
                        this.b = new GeneralNames((ASN1Object)cON_SPEC.getValue());
                        continue block5;
                    }
                    if (n3 == 1) {
                        if (cON_SPEC.countComponents() > 1) {
                            cON_SPEC.forceImplicitlyTagged(ASN.SET);
                        } else if (cON_SPEC.countComponents() == 1 && !(aSN1Object3 = cON_SPEC.getComponentAt(0)).isA(ASN.SET)) {
                            cON_SPEC.forceImplicitlyTagged(ASN.SET);
                        }
                        this.b = new RDN((ASN1Object)cON_SPEC.getValue());
                        continue block5;
                    }
                    throw new InternalErrorException("DistributionPointName: Unknown type [parse]!");
                }
                case 1: {
                    cON_SPEC = (CON_SPEC)aSN1Object2;
                    if (cON_SPEC.isImplicitlyTagged()) {
                        cON_SPEC.forceImplicitlyTagged(ASN.BIT_STRING);
                    }
                    ASN1Object aSN1Object3 = (BIT_STRING)cON_SPEC.getValue();
                    StringBuffer stringBuffer = new StringBuffer(((BIT_STRING)aSN1Object3).getBinaryString()).reverse();
                    this.c = Integer.parseInt(stringBuffer.toString(), 2);
                    continue block5;
                }
                case 2: {
                    cON_SPEC = (CON_SPEC)aSN1Object2;
                    if (cON_SPEC.countComponents() > 1) {
                        cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                    }
                    this.d = new GeneralNames((ASN1Object)aSN1Object2.getValue());
                    continue block5;
                }
                default: {
                    throw new CodingException("Invalid tag: " + n2 + "!");
                }
            }
        }
    }

    public ASN1Object toASN1Object() throws CodingException {
        boolean bl = true;
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.b != null) {
            int n2 = -1;
            if (this.b instanceof GeneralNames) {
                n2 = 0;
            } else if (this.b instanceof RDN) {
                n2 = 1;
            } else {
                throw new InternalErrorException("DistributionPointName: Unknown type [create]!");
            }
            CON_SPEC cON_SPEC = new CON_SPEC(n2, this.b.toASN1Object(), bl);
            sEQUENCE.addComponent(new CON_SPEC(0, cON_SPEC));
        }
        if (this.c != -1) {
            StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.c));
            stringBuffer.reverse();
            sEQUENCE.addComponent(new CON_SPEC(1, new BIT_STRING(stringBuffer.toString()), bl));
        }
        if (this.d != null) {
            sEQUENCE.addComponent(new CON_SPEC(2, this.d.toASN1Object(), bl));
        }
        return sEQUENCE;
    }

    public void setDistributionPointName(ASN1Type aSN1Type) throws IllegalArgumentException {
        if (!(aSN1Type instanceof GeneralNames) && !(aSN1Type instanceof RDN)) {
            throw new IllegalArgumentException("Only instances of GeneralNames or RDN are accepted!");
        }
        this.b = aSN1Type;
    }

    public void setDistributionPointNameURIs(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new NullPointerException("No uri names specified");
        }
        if (this.b == null) {
            this.b = new GeneralNames();
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            ((GeneralNames)this.b).addName(new GeneralName(6, stringArray[i2]));
        }
    }

    public void setReasonFlags(int n2) {
        this.c = n2;
    }

    public void setCrlIssuerName(X509Certificate x509Certificate) {
        if (x509Certificate != null) {
            Name name = (Name)x509Certificate.getSubjectDN();
            if (name == null) {
                throw new NullPointerException("Subject field of the crl issuer cert must not be empty!");
            }
            this.d = new GeneralNames(new GeneralName(4, name));
        } else {
            this.d = null;
        }
    }

    public void setCrlIssuerName(Name name) {
        this.d = name != null ? new GeneralNames(new GeneralName(4, name)) : null;
    }

    public void setCrlIssuer(GeneralNames generalNames) {
        this.d = generalNames;
    }

    public ASN1Type getDistributionPointName() {
        return this.b;
    }

    public String[] getDistributionPointNameURIs() {
        return this.getDistributionPointNameURIs(null);
    }

    public String[] getDistributionPointNameURIs(String string) {
        Object[] objectArray = null;
        if (this.b instanceof GeneralNames) {
            Vector<String> vector = new Vector<String>();
            GeneralNames generalNames = (GeneralNames)this.b;
            Enumeration enumeration = generalNames.getNames();
            while (enumeration.hasMoreElements()) {
                String string2;
                GeneralName generalName = (GeneralName)enumeration.nextElement();
                if (generalName.getType() != 6 || (string2 = (String)generalName.getName()) == null) continue;
                if (string != null) {
                    if (!string2.toLowerCase(Locale.US).startsWith(string)) continue;
                    vector.addElement(string2);
                    continue;
                }
                vector.addElement(string2);
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray == null ? new String[]{} : objectArray;
    }

    public boolean containsUriDpName() {
        boolean bl = false;
        if (this.b != null && this.b instanceof GeneralNames) {
            bl = ((GeneralNames)this.b).containsGeneralName(6);
        }
        return bl;
    }

    public int getReasonFlags() {
        return this.c;
    }

    public boolean isSet(int n2) {
        boolean bl = false;
        if (this.c != -1) {
            bl = (this.c & n2) != 0;
        }
        return bl;
    }

    public GeneralNames getCrlIssuer() {
        return this.d;
    }

    public Name getCrlIssuerName() {
        Name name = null;
        if (this.d != null) {
            Enumeration enumeration = this.d.getNames();
            while (enumeration.hasMoreElements()) {
                GeneralName generalName = (GeneralName)enumeration.nextElement();
                if (generalName.getType() != 4) continue;
                name = (Name)generalName.getName();
            }
        }
        return name;
    }

    public X509CRL loadCrl() throws MalformedURLException, IOException, CRLException {
        return this.loadCrl(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CRL loadCrl(String string, Name name) throws MalformedURLException, IOException, CRLException {
        InputStream inputStream = null;
        try {
            inputStream = this.a(string, name, true);
            X509CRL x509CRL = this.a;
            return x509CRL;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public InputStream loadCrlStream() throws MalformedURLException, IOException {
        return this.loadCrlStream(null, null);
    }

    public InputStream loadCrlStream(String string, Name name) throws MalformedURLException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.a(string, name, false);
        }
        catch (CRLException cRLException) {
            // empty catch block
        }
        return inputStream;
    }

    private InputStream a(String string, Name name, boolean bl) throws MalformedURLException, IOException, CRLException {
        this.a = null;
        InputStream inputStream = null;
        String string2 = null;
        if (this.b != null) {
            if (this.b instanceof GeneralNames) {
                Exception exception = null;
                String[] stringArray = this.getDistributionPointNameURIs();
                if (stringArray.length == 0) {
                    throw new MalformedURLException("Only can handle distribution point general names of type uniformResourceIdentifier!");
                }
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    try {
                        inputStream = this.a(stringArray[i2], bl);
                        exception = null;
                        break;
                    }
                    catch (Exception exception2) {
                        if (exception != null) continue;
                        exception = exception2;
                        continue;
                    }
                }
                if (exception != null) {
                    if (exception instanceof MalformedURLException) {
                        throw (MalformedURLException)exception;
                    }
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    if (exception instanceof CRLException) {
                        throw (CRLException)exception;
                    }
                    throw new CRLException("Error loading crl: " + exception.toString());
                }
            } else {
                if (string == null || !string.toLowerCase(Locale.US).startsWith("ldap")) {
                    throw new MalformedURLException("Need LDAP url for RDN distribution point name!");
                }
                Name name2 = this.getCrlIssuerName();
                if (name2 == null) {
                    name2 = name;
                }
                if (name2 == null) {
                    throw new CRLException("Crl issuer required for RDN distribution point name!");
                }
                string2 = DistributionPoint.a(string, name2, (RDN)this.b, this.e);
                inputStream = this.a(string2, bl);
            }
        } else {
            Name name3 = this.getCrlIssuerName();
            if (name3 != null) {
                if (string == null || !string.toLowerCase(Locale.US).startsWith("ldap")) {
                    throw new MalformedURLException("Need LDAP url if dp name is not set but crl issuer is set!");
                }
                string2 = DistributionPoint.a(string, name3, null, this.e);
            } else {
                string2 = string;
            }
            if (string2 != null) {
                inputStream = this.a(string2, bl);
            } else {
                throw new CRLException("Cannot build url from where to download crl");
            }
        }
        return inputStream;
    }

    private InputStream a(String string, boolean bl) throws MalformedURLException, IOException, CRLException {
        InputStream inputStream;
        URL uRL;
        this.a = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new MalformedURLException("Error loading crl from " + string + ": " + malformedURLException.toString());
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            throw new IOException("Error loading crl from " + string + ": " + iOException.toString());
        }
        if (bl) {
            try {
                this.a = new X509CRL(inputStream);
            }
            catch (Exception exception) {
                throw new CRLException("Error loading crl from " + string + ": " + exception.toString());
            }
        }
        return inputStream;
    }

    private static String a(String string, Name name, RDN rDN, String string2) throws CRLException {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.endsWith("/")) {
            stringBuffer.append("/");
        }
        try {
            Name name2 = name;
            if (rDN != null) {
                name2 = new Name(DerCoder.decode(name.getEncoded()));
                name2.addRDN(rDN);
            }
            stringBuffer.append(name2.getRFC2253String());
        }
        catch (Exception exception) {
            throw new CRLException("Error building LDAP url: " + exception.toString());
        }
        stringBuffer.append("?" + string2);
        return stringBuffer.toString();
    }

    public void setLdapAttributeDescription(String string) {
        if (string == null) {
            throw new NullPointerException("Attribute description may not be null!");
        }
        this.e = string;
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.b != null) {
            stringBuffer.append("DistributionPoint: ");
            stringBuffer.append(this.b.toString() + "\n");
        }
        if (this.c > 0) {
            stringBuffer.append("reasonFlags: ");
            if ((this.c & 1) != 0) {
                stringBuffer.append("unused | ");
            }
            if ((this.c & 2) != 0) {
                stringBuffer.append("keyCompromise | ");
            }
            if ((this.c & 4) != 0) {
                stringBuffer.append("cACompromise | ");
            }
            if ((this.c & 8) != 0) {
                stringBuffer.append("affiliationChanged | ");
            }
            if ((this.c & 0x10) != 0) {
                stringBuffer.append("superseded | ");
            }
            if ((this.c & 0x20) != 0) {
                stringBuffer.append("cessationOfOperation | ");
            }
            if ((this.c & 0x40) != 0) {
                stringBuffer.append("certificateHold | ");
            }
            if ((this.c & 0x80) != 0) {
                stringBuffer.append("privilegeWithdrawn | ");
            }
            if ((this.c & 0x100) != 0) {
                stringBuffer.append("aACompromise | ");
            }
            stringBuffer.setLength(stringBuffer.length() - 3);
            stringBuffer.append("\n");
        }
        if (this.d != null) {
            stringBuffer.append("CRLIssuer:\n");
            stringBuffer.append(this.d.toString() + "\n");
        }
        stringBuffer.setLength((n2 = stringBuffer.length() - 1) < 0 ? 0 : n2);
        return stringBuffer.toString();
    }
}

