/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerInputStream;
import iaik.asn1.NULL;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.pkcs.pkcs1.RSAPssParameterSpec;
import iaik.security.provider.IAIK;
import iaik.utils.CryptoUtils;
import iaik.utils.IaikSecurity;
import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;

public class AlgorithmID
implements ASN1Type,
Cloneable {
    private static boolean I = true;
    private static final Hashtable J = new Hashtable(100);
    private static final Hashtable K = new Hashtable(100);
    private static final Hashtable L = new Hashtable(100);
    private static final Hashtable M = new Hashtable(50);
    private static final HashMap N = new HashMap(10);
    private static Hashtable O = new Hashtable();
    public static final AlgorithmID rsa = new AlgorithmID("2.5.8.1.1", "RSA", "RSA", null, I);
    public static final AlgorithmID elGamal = new AlgorithmID("1.3.14.7.2.1.1", "ElGamal", "ElGamal", a == null ? (a = AlgorithmID.class$("iaik.security.elgamal.ElGamalParameterSpec")) : a);
    public static final AlgorithmID rc2_CBC = new AlgorithmID("1.2.840.113549.3.2", "RC2-CBC", "RC2/CBC/PKCS5Padding", b == null ? (b = AlgorithmID.class$("javax.crypto.spec.RC2ParameterSpec")) : b, I);
    public static final AlgorithmID arcfour;
    public static final AlgorithmID rc4;
    public static final AlgorithmID des_EDE3_CBC;
    public static final AlgorithmID des_CBC;
    public static final AlgorithmID idea_CBC;
    public static final AlgorithmID aes128_CBC;
    public static final AlgorithmID aes192_CBC;
    public static final AlgorithmID aes256_CBC;
    public static final AlgorithmID camellia128_CBC;
    public static final AlgorithmID camellia192_CBC;
    public static final AlgorithmID camellia256_CBC;
    public static final AlgorithmID cast5_CBC;
    public static final AlgorithmID rc5_CBC;
    public static final AlgorithmID aes128_CCM;
    public static final AlgorithmID aes192_CCM;
    public static final AlgorithmID aes256_CCM;
    public static final AlgorithmID aes128_GCM;
    public static final AlgorithmID aes192_GCM;
    public static final AlgorithmID aes256_GCM;
    public static final AlgorithmID aes_CBC_CMAC_128;
    public static final AlgorithmID aes_CBC_CMAC_192;
    public static final AlgorithmID aes_CBC_CMAC_256;
    public static final AlgorithmID chacha20Poly1305;
    public static final AlgorithmID dhKeyAgreement;
    public static final AlgorithmID esdhKeyAgreement;
    public static final AlgorithmID esdh;
    public static final AlgorithmID ssdhKeyAgreement;
    public static final AlgorithmID rsaEncryption;
    public static final AlgorithmID md2WithRSAEncryption;
    public static final AlgorithmID md4WithRSAEncryption;
    public static final AlgorithmID md5WithRSAEncryption;
    public static final AlgorithmID sha1WithRSAEncryption_;
    public static final AlgorithmID sha1WithRSAEncryption;
    public static final AlgorithmID sha224WithRSAEncryption;
    public static final AlgorithmID sha256WithRSAEncryption;
    public static final AlgorithmID sha384WithRSAEncryption;
    public static final AlgorithmID sha512WithRSAEncryption;
    public static final AlgorithmID sha512_224WithRSAEncryption;
    public static final AlgorithmID sha512_256WithRSAEncryption;
    public static final AlgorithmID sha3_224WithRSAEncryption;
    public static final AlgorithmID sha3_256WithRSAEncryption;
    public static final AlgorithmID sha3_384WithRSAEncryption;
    public static final AlgorithmID sha3_512WithRSAEncryption;
    public static final AlgorithmID dsa_;
    public static final AlgorithmID dsa;
    public static final AlgorithmID dsa_With_SHA1;
    public static final AlgorithmID dsaWithSHA;
    public static final AlgorithmID dsaWithSHA1;
    public static final AlgorithmID dsaWithSHA1_;
    public static final AlgorithmID dsaWithSHA224;
    public static final AlgorithmID dsaWithSHA256;
    public static final AlgorithmID dsaWithSHA384;
    public static final AlgorithmID dsaWithSHA512;
    public static final AlgorithmID dsaWithSHA3_224;
    public static final AlgorithmID dsaWithSHA3_256;
    public static final AlgorithmID dsaWithSHA3_384;
    public static final AlgorithmID dsaWithSHA3_512;
    public static final AlgorithmID rsaKem;
    public static final AlgorithmID kdf1;
    public static final AlgorithmID kdf2;
    public static final AlgorithmID kdf3;
    public static final AlgorithmID ecdsa;
    public static final AlgorithmID ecPublicKey;
    public static final AlgorithmID ecDH;
    public static final AlgorithmID dhSinglePass_stdDH_sha1kdf_scheme;
    public static final AlgorithmID dhSinglePass_stdDH_sha224kdf_scheme;
    public static final AlgorithmID dhSinglePass_stdDH_sha256kdf_scheme;
    public static final AlgorithmID dhSinglePass_stdDH_sha384kdf_scheme;
    public static final AlgorithmID dhSinglePass_stdDH_sha512kdf_scheme;
    public static final AlgorithmID dhSinglePass_cofactorDH_sha1kdf_scheme;
    public static final AlgorithmID dhSinglePass_cofactorDH_sha224kdf_scheme;
    public static final AlgorithmID dhSinglePass_cofactorDH_sha256kdf_scheme;
    public static final AlgorithmID dhSinglePass_cofactorDH_sha384kdf_scheme;
    public static final AlgorithmID dhSinglePass_cofactorDH_sha512kdf_scheme;
    public static final AlgorithmID dhSinglePass_stdDH_hkdf_sha256_scheme;
    public static final AlgorithmID dhSinglePass_stdDH_hkdf_sha384_scheme;
    public static final AlgorithmID dhSinglePass_stdDH_hkdf_sha512_scheme;
    public static final AlgorithmID ecka_eg_X963KDF_SHA256;
    public static final AlgorithmID ecka_eg_X963KDF_SHA384;
    public static final AlgorithmID ecka_eg_X963KDF_SHA512;
    public static final AlgorithmID x25519;
    public static final AlgorithmID x448;
    public static final AlgorithmID ed25519;
    public static final AlgorithmID ed448;
    public static final AlgorithmID hkdf_with_SHA256;
    public static final AlgorithmID hkdf_with_SHA384;
    public static final AlgorithmID hkdf_with_SHA512;
    public static final AlgorithmID x9_63_kdf;
    public static final AlgorithmID gost3410;
    public static final AlgorithmID ecdsa_With_SHA1;
    public static final AlgorithmID ecdsa_With_SHA224;
    public static final AlgorithmID ecdsa_With_SHA256;
    public static final AlgorithmID ecdsa_With_SHA384;
    public static final AlgorithmID ecdsa_With_SHA512;
    public static final AlgorithmID ecdsa_With_SHA3_224;
    public static final AlgorithmID ecdsa_With_SHA3_256;
    public static final AlgorithmID ecdsa_With_SHA3_384;
    public static final AlgorithmID ecdsa_With_SHA3_512;
    public static final AlgorithmID ecdsa_plain_With_SHA1;
    public static final AlgorithmID ecdsa_plain_With_SHA224;
    public static final AlgorithmID ecdsa_plain_With_SHA256;
    public static final AlgorithmID ecdsa_plain_With_SHA384;
    public static final AlgorithmID ecdsa_plain_With_SHA512;
    public static final AlgorithmID ecdsa_plain_With_RIPEMD160;
    public static final AlgorithmID rsaSignatureWithRipemd160;
    public static final AlgorithmID rsaSignatureWithRipemd128;
    public static final AlgorithmID rsaSignatureWithRipemd256;
    public static final AlgorithmID sigS_ISO9796_2Withrsa;
    public static final AlgorithmID sigS_ISO9796_2Withsha1;
    public static final AlgorithmID sigS_ISO9796_2Withripemd160;
    public static final AlgorithmID sigS_ISO9796_2rndWithrsa;
    public static final AlgorithmID sigS_ISO9796_2rndWithsha1;
    public static final AlgorithmID sigS_ISO9796_2rndWithripemd160;
    public static final AlgorithmID mgf1;
    public static final AlgorithmID pbeWithMD5AndDES_CBC;
    public static final AlgorithmID pbeWithSHAAnd128BitRC4;
    public static final AlgorithmID pbeWithSHAAnd40BitRC4;
    public static final AlgorithmID pbeWithSHAAnd3_KeyTripleDES_CBC;
    public static final AlgorithmID pbeWithSHAAnd2_KeyTripleDES_CBC;
    public static final AlgorithmID pbeWithSHAAnd128BitRC2_CBC;
    public static final AlgorithmID pbeWithSHAAnd40BitRC2_CBC;
    public static final AlgorithmID pbkdf2;
    public static final AlgorithmID pbes2;
    public static final AlgorithmID pbmac1;
    public static final AlgorithmID pSpecified;
    public static final AlgorithmID md2;
    public static final AlgorithmID md4;
    public static final AlgorithmID md5;
    public static final AlgorithmID sha;
    public static final AlgorithmID sha1;
    public static final AlgorithmID gost3411;
    public static final AlgorithmID sha256;
    public static final AlgorithmID sha224;
    public static final AlgorithmID sha384;
    public static final AlgorithmID sha512;
    public static final AlgorithmID sha512_224;
    public static final AlgorithmID sha512_256;
    public static final AlgorithmID sha3_224;
    public static final AlgorithmID sha3_256;
    public static final AlgorithmID sha3_384;
    public static final AlgorithmID sha3_512;
    public static final AlgorithmID shake128;
    public static final AlgorithmID shake256;
    public static final AlgorithmID shake128Len;
    public static final AlgorithmID shake256Len;
    public static final AlgorithmID ripeMd160_ISO;
    public static final AlgorithmID ripeMd128_ISO;
    public static final AlgorithmID ripeMd160;
    public static final AlgorithmID ripeMd128;
    public static final AlgorithmID ripeMd256;
    public static final AlgorithmID whirlpool;
    public static final AlgorithmID hMAC_GOST;
    public static final AlgorithmID hMAC_MD5;
    public static final AlgorithmID hMAC_SHA1_;
    public static final AlgorithmID hMAC_SHA1;
    public static final AlgorithmID hMAC_SHA224;
    public static final AlgorithmID hMAC_SHA256;
    public static final AlgorithmID hMAC_SHA384;
    public static final AlgorithmID hMAC_SHA512;
    public static final AlgorithmID hMAC_SHA3_224;
    public static final AlgorithmID hMAC_SHA3_256;
    public static final AlgorithmID hMAC_SHA3_384;
    public static final AlgorithmID hMAC_SHA3_512;
    public static final AlgorithmID hMAC_RIPEMD160;
    public static final AlgorithmID cms_3DES_wrap;
    public static final AlgorithmID cms_rc2_wrap;
    public static final AlgorithmID cms_idea_wrap;
    public static final AlgorithmID cms_cast5_wrap;
    public static final AlgorithmID cms_aes128_wrap;
    public static final AlgorithmID cms_aes192_wrap;
    public static final AlgorithmID cms_aes256_wrap;
    public static final AlgorithmID aes128_wrap_pad;
    public static final AlgorithmID aes192_wrap_pad;
    public static final AlgorithmID aes256_wrap_pad;
    public static final AlgorithmID cms_camellia128_wrap;
    public static final AlgorithmID cms_camellia192_wrap;
    public static final AlgorithmID cms_camellia256_wrap;
    public static final AlgorithmID cms_HMACwith3DES_wrap;
    public static final AlgorithmID cms_HMACwithAES_wrap;
    public static final AlgorithmID pwri_kek;
    public static final AlgorithmID zlib_compress;
    public static final AlgorithmID rsaesOAEP;
    public static final AlgorithmID rsassaPss;
    private ObjectID P;
    private ASN1 Q;
    private boolean R;
    static Class a;
    static Class b;
    static Class c;
    static Class d;
    static Class e;
    static Class f;
    static Class g;
    static Class h;
    static Class i;
    static Class j;
    static Class k;
    static Class l;
    static Class m;
    static Class n;
    static Class o;
    static Class p;
    static Class q;
    static Class r;
    static Class s;
    static Class t;
    static Class u;
    static Class v;
    static Class w;
    static Class x;
    static Class y;
    static Class z;
    static Class A;
    static Class B;
    static Class C;
    static Class D;
    static Class E;
    static Class F;
    static Class G;
    static Class H;

    public static void setDefaultEncodeAbsentParametersAsNull(boolean bl) {
        I = bl;
    }

    public static boolean getDoNotIncludeParameters(AlgorithmID algorithmID) {
        return O.get(algorithmID) != null;
    }

    public static void setDoNotIncludeParameters(AlgorithmID algorithmID) {
        O.put(algorithmID, algorithmID);
    }

    public static void setDoIncludeParameters(AlgorithmID algorithmID) {
        O.remove(algorithmID);
    }

    public static boolean changeObjectID(AlgorithmID algorithmID, ObjectID objectID) {
        try {
            String string = (String)J.get(algorithmID.P);
            algorithmID.P = objectID;
            J.put(objectID, string);
            L.put(string, algorithmID);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean changeOIDString(AlgorithmID algorithmID, String string) {
        try {
            String string2 = algorithmID.P.getID();
            String string3 = algorithmID.P.getName();
            String string4 = algorithmID.P.getShortName();
            String string5 = (String)J.get(algorithmID.P);
            ObjectID objectID = null;
            objectID = string3.equals(string2) ? (string4.equals(string2) ? new ObjectID(string) : new ObjectID(string, "", string4)) : (string4.equals(string2) ? new ObjectID(string, string3) : new ObjectID(string, string3, string4));
            algorithmID.P = objectID;
            J.put(objectID, string5);
            L.put(string5, algorithmID);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static void register(String string, String string2, String string3) {
        new AlgorithmID(string, string2, string3);
    }

    public static AlgorithmID getAlgorithmID(String string) {
        AlgorithmID algorithmID = (AlgorithmID)L.get(string);
        return algorithmID == null ? null : (AlgorithmID)algorithmID.clone();
    }

    public static String[] getImplementationNames(AlgorithmID algorithmID) {
        String[] stringArray = null;
        try {
            stringArray = algorithmID.getImplementationNames();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public AlgorithmID() {
        this.P = null;
        this.Q = null;
        this.R = I;
    }

    public AlgorithmID(String string, String string2) {
        this();
        this.P = new ObjectID(string, string2);
    }

    public AlgorithmID(String string, String string2, String string3) {
        this();
        this.P = new ObjectID(string, string2);
        if (string3 != null) {
            J.put(this.P, string3);
            L.put(string3, this);
        }
    }

    public AlgorithmID(String string, String string2, String string3, Class clazz) {
        this(string, string2, string3, clazz, I);
    }

    public AlgorithmID(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3);
        this.R = bl;
    }

    public AlgorithmID(String string, String string2, String string3, Class clazz, boolean bl) {
        String[] stringArray;
        if (string3 == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string3;
        }
        this(string, string2, stringArray, clazz, bl, true, null);
    }

    private AlgorithmID(String string, String string2, String string3, Class clazz, String string4, boolean bl) {
        String[] stringArray;
        if (string3 == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string3;
        }
        this(string, string2, stringArray, clazz, string4, bl, true, null);
    }

    public AlgorithmID(String string, String string2, String[] stringArray, boolean bl) {
        this(string, string2, stringArray, null, bl);
    }

    public AlgorithmID(String string, String string2, String[] stringArray, Class clazz) {
        this(string, string2, stringArray, clazz, I);
    }

    public AlgorithmID(String string, String string2, String[] stringArray, Class clazz, boolean bl) {
        this(string, string2, stringArray, clazz, bl, true, null);
    }

    private AlgorithmID(String string, String string2, String[] stringArray, Class clazz, boolean bl, boolean bl2, String string3) {
        this(string, string2, stringArray, clazz, null, bl, bl2, string3);
    }

    private AlgorithmID(String string, String string2, String[] stringArray, Class clazz, String string3, boolean bl, boolean bl2, String string4) {
        this();
        if (clazz != null && !(v == null ? (v = AlgorithmID.class$("java.security.spec.AlgorithmParameterSpec")) : v).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("algorithmParameterSpec (" + clazz.getName() + ") does not implement AlgorithmParameterSpec!");
        }
        this.P = new ObjectID(string, string2, null, false);
        if (stringArray != null && stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string5 = stringArray[i2];
                if (string5 == null) continue;
                if (i2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string5);
                if (!bl2) continue;
                L.put(string5, this);
            }
            J.put(this.P, stringBuffer.toString());
        }
        if (string4 != null) {
            K.put(this.P, string4);
        }
        if (clazz != null) {
            M.put(this, clazz);
        }
        if (string3 != null) {
            N.put(this, string3);
        }
        this.R = bl;
    }

    public AlgorithmID(ObjectID objectID) {
        this();
        this.P = objectID;
        this.Q = null;
    }

    public AlgorithmID(ObjectID objectID, ASN1Object aSN1Object) {
        this();
        this.P = objectID;
        if (aSN1Object != null) {
            try {
                this.Q = new ASN1(aSN1Object);
            }
            catch (CodingException codingException) {
                // empty catch block
            }
        }
    }

    public AlgorithmID(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public AlgorithmID(DerInputStream derInputStream) throws IOException {
        this();
        DerInputStream derInputStream2 = derInputStream.readSequence();
        this.P = derInputStream2.readObjectID();
        try {
            if (derInputStream2.nextTag() != -1) {
                this.Q = new ASN1(derInputStream2);
            } else {
                this.R = false;
            }
        }
        catch (CodingException codingException) {
            throw new IOException("Error decoding algorithm parameter.");
        }
    }

    public void encodeAbsentParametersAsNull(boolean bl) {
        this.R = bl;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("AlgorithmID must be SEQUENCE!");
        }
        int n2 = aSN1Object.countComponents();
        if (n2 < 1 || n2 > 2) {
            throw new CodingException("Invalid number of components (" + n2 + ") in algorithm id!");
        }
        try {
            this.P = (ObjectID)aSN1Object.getComponentAt(0);
            if (aSN1Object.countComponents() == 2) {
                this.Q = new ASN1(aSN1Object.getComponentAt(1));
            } else {
                this.R = false;
            }
        }
        catch (Exception exception) {
            throw new CodingException("Error parsing algorithmID: " + exception.toString());
        }
    }

    public ASN1Object toASN1Object() {
        return this.toASN1Object(this.R);
    }

    public ASN1Object toASN1Object(boolean bl) {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.P);
        if (this.Q != null) {
            sEQUENCE.addComponent(this.Q.toASN1Object());
        } else if (bl) {
            NULL nULL = new NULL();
            try {
                this.Q = new ASN1(nULL);
            }
            catch (CodingException codingException) {
                // empty catch block
            }
            sEQUENCE.addComponent(nULL);
        }
        return sEQUENCE;
    }

    public String getImplementationName() throws NoSuchAlgorithmException {
        String string = (String)J.get(this.P);
        if (string == null) {
            throw new NoSuchAlgorithmException("No implementation for: " + this.getName());
        }
        if (string.indexOf(",") != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            string = stringTokenizer.nextToken();
        }
        return string;
    }

    public String[] getImplementationNames() throws NoSuchAlgorithmException {
        Object[] objectArray;
        String string = (String)J.get(this.P);
        if (string == null) {
            throw new NoSuchAlgorithmException("No implementation for: " + this.getName());
        }
        Vector<String> vector = new Vector<String>();
        if (string.indexOf(",") != -1) {
            objectArray = new StringTokenizer(string, ",");
            while (objectArray.hasMoreTokens()) {
                vector.add(objectArray.nextToken());
            }
        } else {
            vector.add(string);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getJcaStandardName() throws NoSuchAlgorithmException {
        String string = this.a(true);
        return string;
    }

    private String a(boolean bl) throws NoSuchAlgorithmException {
        String string = (String)K.get(this.P);
        if (string == null) {
            if (rsassaPss.equals(this)) {
                string = AlgorithmID.a(this);
            } else if (bl) {
                string = this.getImplementationName();
            } else {
                throw new NoSuchAlgorithmException("No implementation for: " + this.getName());
            }
        }
        return string;
    }

    private static String a(AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        String string = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            RSAPssParameterSpec rSAPssParameterSpec = (RSAPssParameterSpec)algorithmID.getAlgorithmParameterSpec(IAIK.getInstance());
            if (rSAPssParameterSpec != null) {
                AlgorithmID algorithmID2 = rSAPssParameterSpec.getHashAlgorithm();
                stringBuffer.append(algorithmID2.getImplementationName());
                AlgorithmID algorithmID3 = rSAPssParameterSpec.getMaskGenAlgorithm();
                stringBuffer.append("withRSAand");
                stringBuffer.append(algorithmID3.getJcaStandardName());
                string = stringBuffer.toString();
            } else {
                string = "SHA1withRSAandMGF1";
            }
        }
        catch (Throwable throwable) {
            string = algorithmID.getImplementationName();
        }
        return string;
    }

    public Object getInstance() throws NoSuchAlgorithmException {
        return this.getInstance(null);
    }

    public Object getInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? this.getMessageDigestInstance() : this.getMessageDigestInstance(string);
        }
        catch (Exception exception) {
            try {
                return string == null ? this.getSignatureInstance() : this.getSignatureInstance(string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? this.getCipherInstance() : this.getCipherInstance(string);
                }
                catch (Exception exception3) {
                    try {
                        return string == null ? this.getKeyAgreementInstance() : this.getKeyAgreementInstance(string);
                    }
                    catch (Exception exception4) {
                        try {
                            return string == null ? this.getKeyFactoryInstance() : this.getKeyFactoryInstance(string);
                        }
                        catch (Exception exception5) {
                            try {
                                return string == null ? this.getMacInstance() : this.getMacInstance(string);
                            }
                            catch (Exception exception6) {
                                throw new NoSuchAlgorithmException("No implementation for " + this.P.getName());
                            }
                        }
                    }
                }
            }
        }
    }

    private Object a(String string, Class clazz, Provider provider) throws NoSuchMethodException, NoSuchAlgorithmException {
        List list = this.a(-1);
        return this.a(string, clazz, provider, list);
    }

    private Object a(String string, Class clazz, Provider provider, List list) throws NoSuchMethodException, NoSuchAlgorithmException {
        if (list == null || list.isEmpty()) {
            list = this.a(-1);
        }
        Object object = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                object = IaikSecurity.getEngine((String)iterator.next(), string, clazz, provider);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw noSuchMethodException;
            }
            catch (Exception exception) {
            }
        }
        if (object == null) {
            throw new NoSuchAlgorithmException("No implementation for " + this.P.getName());
        }
        return object;
    }

    public Cipher getCipherInstance() throws NoSuchAlgorithmException {
        return this.getCipherInstance((String)null);
    }

    public Cipher getCipherInstance(String string) throws NoSuchAlgorithmException {
        String[] stringArray = null;
        try {
            stringArray = this.getImplementationNames();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                try {
                    return string == null ? Cipher.getInstance(string2) : Cipher.getInstance(string2, string);
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string3 = this.a(false);
            return string == null ? Cipher.getInstance(string3) : Cipher.getInstance(string3, string);
        }
        catch (Exception exception) {
            try {
                return string == null ? Cipher.getInstance(this.P.getID()) : Cipher.getInstance(this.P.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? Cipher.getInstance(this.P.getName()) : Cipher.getInstance(this.P.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementation for " + this.P.getName());
                }
            }
        }
    }

    public Cipher getCipherInstance(Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            return this.getCipherInstance((String)null);
        }
        try {
            return (Cipher)this.a("Cipher", w == null ? (w = AlgorithmID.class$("javax.crypto.Cipher")) : w, provider);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.getCipherInstance(provider.getName());
        }
    }

    public Signature getSignatureInstance() throws NoSuchAlgorithmException {
        return this.getSignatureInstance((String)null);
    }

    public Signature getSignatureInstance(String string) throws NoSuchAlgorithmException {
        Signature signature = null;
        String[] stringArray = null;
        try {
            stringArray = this.getImplementationNames();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                try {
                    signature = string == null ? Signature.getInstance(string2) : Signature.getInstance(string2, string);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (signature == null) {
            try {
                String string3 = this.a(false);
                signature = string == null ? Signature.getInstance(string3) : Signature.getInstance(string3, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (signature == null) {
            try {
                signature = string == null ? Signature.getInstance(this.P.getID()) : Signature.getInstance(this.P.getID(), string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (signature == null) {
            try {
                signature = string == null ? Signature.getInstance(this.P.getName()) : Signature.getInstance(this.P.getName(), string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (signature != null) {
            if (this.hasParameters()) {
                try {
                    AlgorithmParameterSpec algorithmParameterSpec = this.getAlgorithmParameterSpec(string);
                    if (algorithmParameterSpec != null) {
                        signature.setParameter(algorithmParameterSpec);
                    }
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new NoSuchAlgorithmException("Error converting parameters: " + invalidAlgorithmParameterException);
                }
            }
            return signature;
        }
        throw new NoSuchAlgorithmException("No implementation for " + this.P.getName());
    }

    public Signature getSignatureInstance(Provider provider) throws NoSuchAlgorithmException {
        Signature signature;
        block6: {
            if (provider == null) {
                return this.getSignatureInstance((String)null);
            }
            signature = null;
            try {
                signature = (Signature)this.a("Signature", x == null ? (x = AlgorithmID.class$("java.security.Signature")) : x, provider);
                if (!this.hasParameters()) break block6;
                try {
                    AlgorithmParameterSpec algorithmParameterSpec = this.getAlgorithmParameterSpec(provider);
                    if (algorithmParameterSpec != null) {
                        signature.setParameter(algorithmParameterSpec);
                    }
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new NoSuchAlgorithmException("Error converting parameters: " + invalidAlgorithmParameterException);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                signature = this.getSignatureInstance(provider.getName());
            }
        }
        return signature;
    }

    public MessageDigest getMessageDigestInstance() throws NoSuchAlgorithmException {
        return this.getMessageDigestInstance((String)null);
    }

    public MessageDigest getMessageDigestInstance(String string) throws NoSuchAlgorithmException {
        String[] stringArray = null;
        try {
            stringArray = this.getImplementationNames();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                try {
                    return string == null ? MessageDigest.getInstance(string2) : MessageDigest.getInstance(string2, string);
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string3 = this.a(false);
            return string == null ? MessageDigest.getInstance(string3) : MessageDigest.getInstance(string3, string);
        }
        catch (Exception exception) {
            try {
                return string == null ? MessageDigest.getInstance(this.P.getID()) : MessageDigest.getInstance(this.P.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? MessageDigest.getInstance(this.P.getName()) : MessageDigest.getInstance(this.P.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementation for " + this.P.getName());
                }
            }
        }
    }

    public MessageDigest getMessageDigestInstance(Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            return this.getMessageDigestInstance((String)null);
        }
        try {
            return (MessageDigest)this.a("MessageDigest", y == null ? (y = AlgorithmID.class$("java.security.MessageDigest")) : y, provider);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.getMessageDigestInstance(provider.getName());
        }
    }

    public Mac getMacInstance() throws NoSuchAlgorithmException {
        return this.getMacInstance((String)null);
    }

    public Mac getMacInstance(String string) throws NoSuchAlgorithmException {
        String[] stringArray = null;
        try {
            stringArray = this.getImplementationNames();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                try {
                    return string == null ? Mac.getInstance(string2) : Mac.getInstance(string2, string);
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string3 = this.a(false);
            return string == null ? Mac.getInstance(string3) : Mac.getInstance(string3, string);
        }
        catch (Exception exception) {
            try {
                return string == null ? Mac.getInstance(this.P.getID()) : Mac.getInstance(this.P.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? Mac.getInstance(this.P.getName()) : Mac.getInstance(this.P.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementation for " + this.P.getName());
                }
            }
        }
    }

    public Mac getMacInstance(Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            return this.getMacInstance((String)null);
        }
        try {
            return (Mac)this.a("Mac", z == null ? (z = AlgorithmID.class$("javax.crypto.Mac")) : z, provider);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.getMacInstance(provider.getName());
        }
    }

    public KeyAgreement getKeyAgreementInstance() throws NoSuchAlgorithmException {
        return this.getKeyAgreementInstance((String)null);
    }

    public KeyAgreement getKeyAgreementInstance(String string) throws NoSuchAlgorithmException {
        String[] stringArray = null;
        try {
            stringArray = this.getImplementationNames();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                try {
                    return string == null ? KeyAgreement.getInstance(string2) : KeyAgreement.getInstance(string2, string);
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string3 = this.a(false);
            return string == null ? KeyAgreement.getInstance(string3) : KeyAgreement.getInstance(string3, string);
        }
        catch (Exception exception) {
            try {
                return string == null ? KeyAgreement.getInstance(this.P.getID()) : KeyAgreement.getInstance(this.P.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? KeyAgreement.getInstance(this.P.getName()) : KeyAgreement.getInstance(this.P.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementation for " + this.P.getName());
                }
            }
        }
    }

    public KeyAgreement getKeyAgreementInstance(Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            return this.getKeyAgreementInstance((String)null);
        }
        try {
            return (KeyAgreement)this.a("KeyAgreement", A == null ? (A = AlgorithmID.class$("javax.crypto.KeyAgreement")) : A, provider);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.getKeyAgreementInstance(provider.getName());
        }
    }

    public KeyFactory getKeyFactoryInstance() throws NoSuchAlgorithmException {
        return this.getKeyFactoryInstance((String)null);
    }

    public KeyFactory getKeyFactoryInstance(String string) throws NoSuchAlgorithmException {
        String[] stringArray = null;
        try {
            stringArray = this.getImplementationNames();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                try {
                    return string == null ? KeyFactory.getInstance(string2) : KeyFactory.getInstance(string2, string);
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string3 = this.a(false);
            return string == null ? KeyFactory.getInstance(string3) : KeyFactory.getInstance(string3, string);
        }
        catch (Exception exception) {
            try {
                return string == null ? KeyFactory.getInstance(this.P.getID()) : KeyFactory.getInstance(this.P.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? KeyFactory.getInstance(this.P.getName()) : KeyFactory.getInstance(this.P.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementation for " + this.P.getName());
                }
            }
        }
    }

    public KeyFactory getKeyFactoryInstance(Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            return this.getKeyFactoryInstance((String)null);
        }
        try {
            return (KeyFactory)this.a("KeyFactory", B == null ? (B = AlgorithmID.class$("java.security.KeyFactory")) : B, provider);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.getKeyFactoryInstance(provider.getName());
        }
    }

    public KeyPairGenerator getKeyPairGeneratorInstance() throws NoSuchAlgorithmException {
        return this.getKeyPairGeneratorInstance((String)null);
    }

    public KeyPairGenerator getKeyPairGeneratorInstance(String string) throws NoSuchAlgorithmException {
        String[] stringArray = null;
        try {
            stringArray = this.getImplementationNames();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                try {
                    return string == null ? KeyPairGenerator.getInstance(string2) : KeyPairGenerator.getInstance(string2, string);
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string3 = this.a(false);
            return string == null ? KeyPairGenerator.getInstance(string3) : KeyPairGenerator.getInstance(string3, string);
        }
        catch (Exception exception) {
            try {
                return string == null ? KeyPairGenerator.getInstance(this.P.getID()) : KeyPairGenerator.getInstance(this.P.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? KeyPairGenerator.getInstance(this.P.getName()) : KeyPairGenerator.getInstance(this.P.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementation for " + this.P.getName());
                }
            }
        }
    }

    public KeyPairGenerator getKeyPairGeneratorInstance(Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            return this.getKeyPairGeneratorInstance((String)null);
        }
        try {
            return (KeyPairGenerator)this.a("KeyPairGenerator", C == null ? (C = AlgorithmID.class$("java.security.KeyPairGenerator")) : C, provider);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.getKeyPairGeneratorInstance(provider.getName());
        }
    }

    public KeyGenerator getKeyGeneratorInstance() throws NoSuchAlgorithmException {
        return this.getKeyGeneratorInstance((String)null);
    }

    public KeyGenerator getKeyGeneratorInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? KeyGenerator.getInstance(this.getRawImplementationName()) : KeyGenerator.getInstance(this.getRawImplementationName(), string);
        }
        catch (Exception exception) {
            String[] stringArray = null;
            try {
                stringArray = this.getImplementationNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string2 = stringArray[i2];
                    try {
                        return string == null ? KeyGenerator.getInstance(string2) : KeyGenerator.getInstance(string2, string);
                    }
                    catch (Exception exception2) {
                        continue;
                    }
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                String string3 = this.a(false);
                return string == null ? KeyGenerator.getInstance(string3) : KeyGenerator.getInstance(string3, string);
            }
            catch (Exception exception4) {
                try {
                    return string == null ? KeyGenerator.getInstance(this.P.getID()) : KeyGenerator.getInstance(this.P.getID(), string);
                }
                catch (Exception exception5) {
                    try {
                        return string == null ? KeyGenerator.getInstance(this.P.getName()) : KeyGenerator.getInstance(this.P.getName(), string);
                    }
                    catch (Exception exception6) {
                        throw new NoSuchAlgorithmException("No implementation for " + this.P.getName());
                    }
                }
            }
        }
    }

    public KeyGenerator getKeyGeneratorInstance(Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            return this.getKeyGeneratorInstance((String)null);
        }
        List list = this.a(0);
        try {
            return (KeyGenerator)this.a("KeyGenerator", D == null ? (D = AlgorithmID.class$("javax.crypto.KeyGenerator")) : D, provider, list);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.getKeyGeneratorInstance(provider.getName());
        }
    }

    private List a(int n2) throws NoSuchAlgorithmException {
        String string;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(4);
        String string2 = null;
        try {
            if (n2 > -1) {
                string2 = this.getRawImplementationName();
                if (n2 == 0) {
                    arrayList.add(string2);
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        try {
            object = this.getImplementationNames();
            for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                string = object[i2];
                if (string == null || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (n2 == 1 && !arrayList.contains(string2)) {
            arrayList.add(string2);
        }
        object = null;
        try {
            object = this.a(false);
            if (object != null && !arrayList.contains(object)) {
                arrayList.add(object);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        String string3 = this.P.getID();
        if (!arrayList.contains(string3)) {
            arrayList.add(string3);
        }
        if (!arrayList.contains(string = this.P.getName())) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public SecretKeyFactory getSecretKeyFactoryInstance() throws NoSuchAlgorithmException {
        return this.getSecretKeyFactoryInstance((String)null);
    }

    public SecretKeyFactory getSecretKeyFactoryInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? SecretKeyFactory.getInstance(this.getRawImplementationName()) : SecretKeyFactory.getInstance(this.getRawImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                return string == null ? SecretKeyFactory.getInstance(this.P.getID()) : SecretKeyFactory.getInstance(this.P.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? SecretKeyFactory.getInstance(this.P.getName()) : SecretKeyFactory.getInstance(this.P.getName(), string);
                }
                catch (Exception exception3) {
                    String[] stringArray = null;
                    try {
                        stringArray = this.getImplementationNames();
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            String string2 = stringArray[i2];
                            try {
                                return string == null ? SecretKeyFactory.getInstance(string2) : SecretKeyFactory.getInstance(string2, string);
                            }
                            catch (Exception exception4) {
                                continue;
                            }
                        }
                    }
                    catch (Exception exception5) {
                        // empty catch block
                    }
                    try {
                        String string3 = this.a(false);
                        return string == null ? SecretKeyFactory.getInstance(string3) : SecretKeyFactory.getInstance(string3, string);
                    }
                    catch (Exception exception6) {
                        throw new NoSuchAlgorithmException("No implementation for " + this.P.getName());
                    }
                }
            }
        }
    }

    public SecretKeyFactory getSecretKeyFactoryInstance(Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            return this.getSecretKeyFactoryInstance((String)null);
        }
        List list = this.a(0);
        try {
            return (SecretKeyFactory)this.a("SecretKeyFactory", E == null ? (E = AlgorithmID.class$("javax.crypto.SecretKeyFactory")) : E, provider, list);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.getSecretKeyFactoryInstance(provider.getName());
        }
    }

    private AlgorithmParameters a(String string) throws NoSuchAlgorithmException {
        String[] stringArray = null;
        try {
            stringArray = this.getImplementationNames();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                try {
                    return string == null ? AlgorithmParameters.getInstance(string2) : AlgorithmParameters.getInstance(string2, string);
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string3 = this.a(false);
            return string == null ? AlgorithmParameters.getInstance(string3) : AlgorithmParameters.getInstance(string3, string);
        }
        catch (Exception exception) {
            try {
                return string == null ? AlgorithmParameters.getInstance(this.getRawImplementationName()) : AlgorithmParameters.getInstance(this.getRawImplementationName(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? AlgorithmParameters.getInstance(this.P.getID()) : AlgorithmParameters.getInstance(this.P.getID(), string);
                }
                catch (Exception exception3) {
                    try {
                        return string == null ? AlgorithmParameters.getInstance(this.P.getName()) : AlgorithmParameters.getInstance(this.P.getName(), string);
                    }
                    catch (Exception exception4) {
                        throw new NoSuchAlgorithmException("No implementation for " + this.P.getName());
                    }
                }
            }
        }
    }

    public AlgorithmParameters getAlgorithmParametersInstance(Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            return this.a(null);
        }
        List list = this.a(1);
        try {
            return (AlgorithmParameters)this.a("AlgorithmParameters", F == null ? (F = AlgorithmID.class$("java.security.AlgorithmParameters")) : F, provider, list);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.a(provider.getName());
        }
    }

    public MaskGenerationAlgorithm getMaskGenerationAlgorithmInstance() throws NoSuchAlgorithmException {
        return this.getMaskGenerationAlgorithmInstance((String)null);
    }

    public MaskGenerationAlgorithm getMaskGenerationAlgorithmInstance(String string) throws NoSuchAlgorithmException {
        String[] stringArray = null;
        try {
            stringArray = this.getImplementationNames();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                try {
                    return string == null ? MaskGenerationAlgorithm.getInstance(string2) : MaskGenerationAlgorithm.getInstance(string2, string);
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string3 = this.a(false);
            return string == null ? MaskGenerationAlgorithm.getInstance(string3) : MaskGenerationAlgorithm.getInstance(string3, string);
        }
        catch (Exception exception) {
            try {
                return string == null ? MaskGenerationAlgorithm.getInstance(this.P.getID()) : MaskGenerationAlgorithm.getInstance(this.P.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    return string == null ? MaskGenerationAlgorithm.getInstance(this.P.getName()) : MaskGenerationAlgorithm.getInstance(this.P.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementation for " + this.P.getName());
                }
            }
        }
    }

    public MaskGenerationAlgorithm getMaskGenerationAlgorithmInstance(Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            return this.getMaskGenerationAlgorithmInstance((String)null);
        }
        try {
            return (MaskGenerationAlgorithm)this.a("MaskGenerationAlgorithm", G == null ? (G = AlgorithmID.class$("iaik.pkcs.pkcs1.MaskGenerationAlgorithm")) : G, provider);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.getMaskGenerationAlgorithmInstance(provider.getName());
        }
    }

    public String getRawImplementationName() throws NoSuchAlgorithmException {
        String string = this.getImplementationName();
        int n2 = string.indexOf("RSA");
        if (n2 != -1) {
            n2 = string.indexOf("PSS");
            string = n2 != -1 ? "RSASSA-PSS" : ((n2 = string.indexOf("OAEP")) != -1 ? "RSAES-OAEP" : "RSA");
        } else {
            n2 = string.indexOf("DSA");
            if (n2 != -1) {
                n2 = string.indexOf("ECDSA");
                string = n2 != -1 ? "ECDSA" : "DSA";
            } else {
                n2 = string.indexOf("/");
                if (n2 != -1) {
                    string = string.substring(0, n2);
                }
            }
        }
        return string;
    }

    private String a() throws NoSuchAlgorithmException {
        String string = this.getImplementationName();
        string = string.indexOf("OAEP") != -1 ? "OAEP" : (string.indexOf("GCM") != -1 ? "GCM" : this.getRawImplementationName());
        return string;
    }

    public Object clone() {
        AlgorithmID algorithmID = null;
        try {
            algorithmID = (AlgorithmID)super.clone();
            if (this.P != null) {
                algorithmID.P = (ObjectID)this.P.clone();
            }
            if (this.Q != null) {
                algorithmID.Q = (ASN1)this.Q.clone();
            }
            algorithmID.R = this.R;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return algorithmID;
    }

    public ObjectID getAlgorithm() {
        return this.P;
    }

    public ASN1Object getParameter() {
        ASN1Object aSN1Object = null;
        if (this.Q != null) {
            aSN1Object = this.Q.toASN1Object();
        }
        return aSN1Object;
    }

    public boolean hasParameters() {
        ASN1Object aSN1Object;
        boolean bl = false;
        if (this.Q != null && !(aSN1Object = this.Q.toASN1Object()).isA(ASN.NULL)) {
            bl = true;
        }
        return bl;
    }

    public AlgorithmParameters getAlgorithmParameters(String string) throws NoSuchAlgorithmException {
        return this.getAlgorithmParameters(string, (String)null);
    }

    public AlgorithmParameters getAlgorithmParameters(String string, String string2) throws NoSuchAlgorithmException {
        try {
            if (this.Q == null || this.Q.toASN1Object().isA(ASN.NULL)) {
                throw new NoSuchAlgorithmException("No algorithm parameters.");
            }
            AlgorithmParameters algorithmParameters = null;
            algorithmParameters = string != null ? (string2 == null ? AlgorithmParameters.getInstance(string) : AlgorithmParameters.getInstance(string, string2)) : this.a(string2);
            algorithmParameters.init(this.Q.toByteArray());
            return algorithmParameters;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException("No such provider: " + string2);
        }
        catch (IOException iOException) {
            throw new NoSuchAlgorithmException(iOException.toString());
        }
    }

    public AlgorithmParameters getAlgorithmParameters(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            return this.getAlgorithmParameters(string, (String)null);
        }
        try {
            if (this.Q == null || this.Q.toASN1Object().isA(ASN.NULL)) {
                throw new NoSuchAlgorithmException("No algorithm parameters.");
            }
            AlgorithmParameters algorithmParameters = null;
            if (string != null) {
                try {
                    algorithmParameters = (AlgorithmParameters)IaikSecurity.getEngine(string, "AlgorithmParameters", F == null ? (F = AlgorithmID.class$("java.security.AlgorithmParameters")) : F, provider);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    algorithmParameters = AlgorithmParameters.getInstance(string, provider.getName());
                }
            } else {
                algorithmParameters = this.getAlgorithmParametersInstance(provider);
            }
            algorithmParameters.init(this.Q.toByteArray());
            return algorithmParameters;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException("No such provider: " + provider);
        }
        catch (IOException iOException) {
            throw new NoSuchAlgorithmException(iOException.toString());
        }
    }

    public AlgorithmParameters getAlgorithmParameters() throws NoSuchAlgorithmException {
        if (this.Q == null || this.Q.toASN1Object().isA(ASN.NULL)) {
            return null;
        }
        return this.getAlgorithmParameters(null, (String)null);
    }

    public void setAlgorithmParameters(AlgorithmParameters algorithmParameters) {
        if (algorithmParameters == null) {
            this.Q = null;
        } else {
            try {
                this.Q = new ASN1(algorithmParameters.getEncoded());
            }
            catch (CodingException codingException) {
                throw new RuntimeException(codingException.toString());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
        }
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.setAlgorithmParameterSpec(algorithmParameterSpec, (String)null);
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec, String string) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            this.Q = null;
        } else {
            try {
                AlgorithmParameters algorithmParameters = this.a(string);
                algorithmParameters.init(algorithmParameterSpec);
                this.setAlgorithmParameters(algorithmParameters);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException(exception.toString());
            }
        }
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec, Provider provider) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            this.Q = null;
        } else {
            try {
                AlgorithmParameters algorithmParameters = this.getAlgorithmParametersInstance(provider);
                algorithmParameters.init(algorithmParameterSpec);
                this.setAlgorithmParameters(algorithmParameters);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException(exception.toString());
            }
        }
    }

    public void setParameter(ASN1Object aSN1Object) {
        if (aSN1Object == null) {
            this.Q = null;
        } else {
            try {
                this.Q = new ASN1(aSN1Object);
            }
            catch (CodingException codingException) {
                // empty catch block
            }
        }
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() throws InvalidAlgorithmParameterException {
        return this.getAlgorithmParameterSpec((String)null);
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec(String string) throws InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec;
        InvalidAlgorithmParameterException invalidAlgorithmParameterException;
        block7: {
            invalidAlgorithmParameterException = null;
            algorithmParameterSpec = null;
            Class<?> clazz = (Class<?>)M.get(this);
            try {
                algorithmParameterSpec = this.getAlgorithmParameterSpec((Class)clazz, string);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException2) {
                invalidAlgorithmParameterException = invalidAlgorithmParameterException2;
                String string2 = (String)N.get(this);
                if (string2 == null) break block7;
                try {
                    clazz = Class.forName(string2);
                }
                catch (Exception exception) {
                    throw invalidAlgorithmParameterException;
                }
                try {
                    algorithmParameterSpec = this.getAlgorithmParameterSpec(clazz, string);
                    invalidAlgorithmParameterException = null;
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException3) {
                    // empty catch block
                }
            }
        }
        if (invalidAlgorithmParameterException != null) {
            throw invalidAlgorithmParameterException;
        }
        return algorithmParameterSpec;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec(Class clazz, String string) throws InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (clazz != null && this.hasParameters()) {
            if (!(v == null ? (v = AlgorithmID.class$("java.security.spec.AlgorithmParameterSpec")) : v).isAssignableFrom(clazz)) {
                throw new InvalidAlgorithmParameterException("parameterSpecClass (" + clazz.getName() + ") does not implement AlgorithmParameterSpec!");
            }
            AlgorithmParameters algorithmParameters = null;
            String[] stringArray = null;
            NoSuchAlgorithmException noSuchAlgorithmException = null;
            try {
                stringArray = this.getImplementationNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string2 = stringArray[i2];
                    try {
                        algorithmParameters = this.getAlgorithmParameters(string2, string);
                        break;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                        if (noSuchAlgorithmException != null) continue;
                        noSuchAlgorithmException = noSuchAlgorithmException2;
                        continue;
                    }
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException3) {
                noSuchAlgorithmException = noSuchAlgorithmException3;
            }
            if (algorithmParameters == null) {
                try {
                    algorithmParameters = this.getAlgorithmParameters(this.a(), string);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException4) {
                    throw new InvalidAlgorithmParameterException("No AlgorithmParameters implementation available: " + noSuchAlgorithmException);
                }
            }
            try {
                algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(clazz);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("No AlgorithmParameters implementation available: " + invalidParameterSpecException);
            }
        }
        return algorithmParameterSpec;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec(Provider provider) throws InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec;
        InvalidAlgorithmParameterException invalidAlgorithmParameterException;
        block7: {
            invalidAlgorithmParameterException = null;
            algorithmParameterSpec = null;
            Class<?> clazz = (Class<?>)M.get(this);
            try {
                algorithmParameterSpec = this.getAlgorithmParameterSpec((Class)clazz, provider);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException2) {
                invalidAlgorithmParameterException = invalidAlgorithmParameterException2;
                String string = (String)N.get(this);
                if (string == null) break block7;
                try {
                    clazz = Class.forName(string);
                }
                catch (Exception exception) {
                    throw invalidAlgorithmParameterException;
                }
                try {
                    algorithmParameterSpec = this.getAlgorithmParameterSpec(clazz, provider);
                    invalidAlgorithmParameterException = null;
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException3) {
                    // empty catch block
                }
            }
        }
        if (invalidAlgorithmParameterException != null) {
            throw invalidAlgorithmParameterException;
        }
        return algorithmParameterSpec;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec(Class clazz, Provider provider) throws InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (clazz != null && this.hasParameters()) {
            if (!(v == null ? (v = AlgorithmID.class$("java.security.spec.AlgorithmParameterSpec")) : v).isAssignableFrom(clazz)) {
                throw new InvalidAlgorithmParameterException("parameterSpecClass (" + clazz.getName() + ") does not implement AlgorithmParameterSpec!");
            }
            AlgorithmParameters algorithmParameters = null;
            String[] stringArray = null;
            NoSuchAlgorithmException noSuchAlgorithmException = null;
            try {
                stringArray = this.getImplementationNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string = stringArray[i2];
                    try {
                        algorithmParameters = this.getAlgorithmParameters(string, provider);
                        break;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                        if (noSuchAlgorithmException != null) continue;
                        noSuchAlgorithmException = noSuchAlgorithmException2;
                        continue;
                    }
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException3) {
                noSuchAlgorithmException = noSuchAlgorithmException3;
            }
            if (algorithmParameters == null) {
                try {
                    algorithmParameters = this.getAlgorithmParameters(this.getRawImplementationName(), provider);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException4) {
                    throw new InvalidAlgorithmParameterException("No AlgorithmParameters implementation available: " + noSuchAlgorithmException);
                }
            }
            try {
                algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(clazz);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("No AlgorithmParameters implementation available: " + invalidParameterSpecException);
            }
        }
        return algorithmParameterSpec;
    }

    public AlgorithmParameterGenerator getAlgorithmParameterGeneratorInstance(String string) throws NoSuchAlgorithmException {
        try {
            return string == null ? AlgorithmParameterGenerator.getInstance(this.getRawImplementationName()) : AlgorithmParameterGenerator.getInstance(this.getRawImplementationName(), string);
        }
        catch (Exception exception) {
            String[] stringArray = null;
            try {
                stringArray = this.getImplementationNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string2 = stringArray[i2];
                    try {
                        return string == null ? AlgorithmParameterGenerator.getInstance(string2) : AlgorithmParameterGenerator.getInstance(string2, string);
                    }
                    catch (Exception exception2) {
                        continue;
                    }
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                String string3 = this.a(false);
                return string == null ? AlgorithmParameterGenerator.getInstance(string3) : AlgorithmParameterGenerator.getInstance(string3, string);
            }
            catch (Exception exception4) {
                try {
                    return string == null ? AlgorithmParameterGenerator.getInstance(this.P.getID()) : AlgorithmParameterGenerator.getInstance(this.P.getID(), string);
                }
                catch (Exception exception5) {
                    try {
                        return string == null ? AlgorithmParameterGenerator.getInstance(this.P.getName()) : AlgorithmParameterGenerator.getInstance(this.P.getName(), string);
                    }
                    catch (Exception exception6) {
                        throw new NoSuchAlgorithmException("No implementation for " + this.P.getName());
                    }
                }
            }
        }
    }

    public AlgorithmParameterGenerator getAlgorithmParameterGeneratorInstance(Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            return this.getAlgorithmParameterGeneratorInstance((String)null);
        }
        List list = this.a(0);
        try {
            return (AlgorithmParameterGenerator)this.a("AlgorithmParameterGenerator", H == null ? (H = AlgorithmID.class$("java.security.AlgorithmParameterGenerator")) : H, provider, list);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.getAlgorithmParameterGeneratorInstance(provider.getName());
        }
    }

    public AlgorithmParameterGenerator getAlgorithmParameterGeneratorInstance() throws NoSuchAlgorithmException {
        return this.getAlgorithmParameterGeneratorInstance((String)null);
    }

    public String getName() {
        return this.P.getName();
    }

    public boolean equals(Object object) {
        return this.equals(object, false);
    }

    public boolean equals(Object object, boolean bl) {
        boolean bl2 = false;
        if (this == object) {
            bl2 = true;
        } else if (!(object instanceof AlgorithmID)) {
            bl2 = false;
        } else {
            AlgorithmID algorithmID = (AlgorithmID)object;
            bl2 = this.P.equals(algorithmID.P);
            if (bl2 && bl) {
                ASN1 aSN1;
                ASN1 aSN12 = this.Q;
                if (aSN12 != null && aSN12.toASN1Object().isA(ASN.NULL)) {
                    aSN12 = null;
                }
                if ((aSN1 = algorithmID.Q) != null && aSN1.toASN1Object().isA(ASN.NULL)) {
                    aSN1 = null;
                }
                bl2 = aSN12 != null && aSN1 != null ? CryptoUtils.equalsBlock(aSN12.toByteArray(), aSN1.toByteArray()) : aSN12 == null && aSN1 == null;
            }
        }
        return bl2;
    }

    public int hashCode() {
        return this.P.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.P.getNameAndID() + " ");
        if (this.Q != null && !this.Q.toASN1Object().isA(ASN.NULL)) {
            stringBuffer.append(" with parameter");
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        rc4 = arcfour = new AlgorithmID("1.2.840.113549.3.4", "ARCFOUR", "ARCFOUR/ECB/NoPadding", null, I);
        des_EDE3_CBC = new AlgorithmID("1.2.840.113549.3.7", "DES-EDE3-CBC", "DESede/CBC/PKCS5Padding", c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, I);
        des_CBC = new AlgorithmID("1.3.14.3.2.7", "DES-CBC", "DES/CBC/PKCS5Padding", c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, I);
        idea_CBC = new AlgorithmID("1.3.6.1.4.1.188.7.1.1.2", "IDEA-CBC", "IDEA/CBC/PKCS5Padding", c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, I);
        aes128_CBC = new AlgorithmID("2.16.840.1.101.3.4.1.2", "AES128-CBC", new String[]{"AES128/CBC/PKCS5Padding", "AES/CBC/PKCS5Padding", "AES_128/CBC/PKCS5Padding"}, c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, I, true, "AES_128/CBC/PKCS5Padding");
        aes192_CBC = new AlgorithmID("2.16.840.1.101.3.4.1.22", "AES192-CBC", new String[]{"AES192/CBC/PKCS5Padding", "AES_192/CBC/PKCS5Padding"}, c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, I, true, "AES_192/CBC/PKCS5Padding");
        aes256_CBC = new AlgorithmID("2.16.840.1.101.3.4.1.42", "AES256-CBC", new String[]{"AES256/CBC/PKCS5Padding", "AES_256/CBC/PKCS5Padding"}, c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, I, true, "AES_256/CBC/PKCS5Padding");
        camellia128_CBC = new AlgorithmID("1.2.392.200011.61.1.1.1.2", "Camellia128-CBC", new String[]{"Camellia128/CBC/PKCS5Padding", "Camellia/CBC/PKCS5Padding", "Camellia_128/CBC/PKCS5Padding"}, c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, I, true, "Camellia_128/CBC/PKCS5Padding");
        camellia192_CBC = new AlgorithmID("1.2.392.200011.61.1.1.1.3", "Camellia192-CBC", new String[]{"Camellia192/CBC/PKCS5Padding", "Camellia_192/CBC/PKCS5Padding"}, c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, I, true, "Camellia_192/CBC/PKCS5Padding");
        camellia256_CBC = new AlgorithmID("1.2.392.200011.61.1.1.1.4", "Camellia256-CBC", new String[]{"Camellia256/CBC/PKCS5Padding", "Camellia_256/CBC/PKCS5Padding"}, c == null ? (c = AlgorithmID.class$("javax.crypto.spec.IvParameterSpec")) : c, I, true, "Camellia_256/CBC/PKCS5Padding");
        cast5_CBC = new AlgorithmID("1.2.840.113533.7.66.10", "CAST5-CBC", "CAST5/CBC/PKCS5Padding", d == null ? (d = AlgorithmID.class$("iaik.security.cipher.CAST128ParameterSpec")) : d, I);
        rc5_CBC = new AlgorithmID("1.2.840.113549.3.8", "RC5-CBC", "RC5/CBC/PKCS5Padding", e == null ? (e = AlgorithmID.class$("javax.crypto.spec.RC5ParameterSpec")) : e, I);
        aes128_CCM = new AlgorithmID("2.16.840.1.101.3.4.1.7", "AES128-CCM", new String[]{"AES128/CCM/NoPadding", "AES/CCM/NoPadding", "AES_128/CCM/NoPadding"}, f == null ? (f = AlgorithmID.class$("iaik.security.cipher.CCMParameterSpec")) : f, I, true, "AES_128/CCM/NoPadding");
        aes192_CCM = new AlgorithmID("2.16.840.1.101.3.4.1.27", "AES192-CCM", new String[]{"AES192/CCM/NoPadding", "AES_192/CCM/NoPadding"}, f == null ? (f = AlgorithmID.class$("iaik.security.cipher.CCMParameterSpec")) : f, I, true, "AES_192/CCM/NoPadding");
        aes256_CCM = new AlgorithmID("2.16.840.1.101.3.4.1.47", "AES256-CCM", new String[]{"AES256/CCM/NoPadding", "AES_256/CCM/NoPadding"}, f == null ? (f = AlgorithmID.class$("iaik.security.cipher.CCMParameterSpec")) : f, I, true, "AES_256/CCM/NoPadding");
        aes128_GCM = new AlgorithmID("2.16.840.1.101.3.4.1.6", "AES128-GCM", new String[]{"AES128/GCM/NoPadding", "AES/GCM/NoPadding", "AES_128/GCM/NoPadding"}, g == null ? (g = AlgorithmID.class$("iaik.security.cipher.GCMParameterSpec")) : g, "javax.crypto.spec.GCMParameterSpec", I, true, "AES_128/GCM/NoPadding");
        aes192_GCM = new AlgorithmID("2.16.840.1.101.3.4.1.26", "AES192-GCM", new String[]{"AES192/GCM/NoPadding", "AES_192/GCM/NoPadding"}, g == null ? (g = AlgorithmID.class$("iaik.security.cipher.GCMParameterSpec")) : g, "javax.crypto.spec.GCMParameterSpec", I, true, "AES_192/GCM/NoPadding");
        aes256_GCM = new AlgorithmID("2.16.840.1.101.3.4.1.46", "AES256-GCM", new String[]{"AES256/GCM/NoPadding", "AES_256/GCM/NoPadding"}, g == null ? (g = AlgorithmID.class$("iaik.security.cipher.GCMParameterSpec")) : g, "javax.crypto.spec.GCMParameterSpec", I, true, "AES_256/GCM/NoPadding");
        aes_CBC_CMAC_128 = new AlgorithmID("0.4.0.127.0.7.1.3.1.1.2", "AES-CBC-CMAC-128", new String[]{"AESCBCCMac128/CBC/PKCS5Padding", "AESCBCCMac_128/CBC/PKCS5Padding"}, h == null ? (h = AlgorithmID.class$("iaik.security.cipher.CBCCMacParameterSpec")) : h, I, true, "AESCBCCMac_128/CBC/PKCS5Padding");
        aes_CBC_CMAC_192 = new AlgorithmID("0.4.0.127.0.7.1.3.1.1.3", "AES-CBC-CMAC-192", new String[]{"AESCBCCMac192/CBC/PKCS5Padding", "AESCBCCMac_192/CBC/PKCS5Padding"}, h == null ? (h = AlgorithmID.class$("iaik.security.cipher.CBCCMacParameterSpec")) : h, I, true, "AESCBCCMac_192/CBC/PKCS5Padding");
        aes_CBC_CMAC_256 = new AlgorithmID("0.4.0.127.0.7.1.3.1.1.4", "AES-CBC-CMAC-256", new String[]{"AESCBCCMac256/CBC/PKCS5Padding", "AESCBCCMac_256/CBC/PKCS5Padding"}, h == null ? (h = AlgorithmID.class$("iaik.security.cipher.CBCCMacParameterSpec")) : h, I, true, "AESCBCCMac_256/CBC/PKCS5Padding");
        chacha20Poly1305 = new AlgorithmID("1.2.840.113549.1.9.16.3.18", "ChaCha20Poly1305", new String[]{"ChaCha20-Poly1305/NONE/NoPadding", "ChaCha20Poly1305/NONE/NoPadding"}, i == null ? (i = AlgorithmID.class$("iaik.security.cipher.ChaCha20Poly1305ParameterSpec")) : i, I, true, "ChaCha20-Poly1305/NONE/NoPadding");
        dhKeyAgreement = new AlgorithmID("1.2.840.113549.1.3.1", "DH Key Agreement", new String[]{"DH", "DiffieHellman"}, null, I, true, "DiffieHellman");
        esdhKeyAgreement = new AlgorithmID("1.2.840.113549.1.9.16.3.5", "ESDH Key Agreement", "ESDH", null, I);
        esdh = new AlgorithmID("1.2.840.10046.2.1", "ESDH", "ESDH", null, I);
        ssdhKeyAgreement = new AlgorithmID("1.2.840.113549.1.9.16.3.10", "SSDH Key Agreement", "SSDH", null, I);
        rsaEncryption = new AlgorithmID("1.2.840.113549.1.1.1", "rsaEncryption", "RSA", null, true);
        md2WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.2", "md2WithRSAEncryption", new String[]{"MD2/RSA", "MD2withRSA"}, null, true, true, "MD2withRSA");
        md4WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.3", "md4WithRSAEncryption", new String[]{"MD4/RSA", "MD4withRSA"}, null, true, true, "MD4withRSA");
        md5WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.4", "md5WithRSAEncryption", new String[]{"MD5/RSA", "MD5withRSA"}, null, true, true, "MD5withRSA");
        sha1WithRSAEncryption_ = new AlgorithmID("1.3.14.3.2.29", "sha1WithRSAEncryption", new String[]{"SHA1/RSA"}, null, true, false, "SHA1withRSA");
        sha1WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.5", "sha1WithRSAEncryption", new String[]{"SHA1/RSA", "SHA-1/RSA", "SHA/RSA", "SHA1withRSA"}, null, true, true, "SHA1withRSA");
        sha224WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.14", "sha224WithRSAEncryption", new String[]{"SHA224/RSA", "SHA-224/RSA", "SHA224withRSA"}, null, true, true, "SHA224withRSA");
        sha256WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.11", "sha256WithRSAEncryption", new String[]{"SHA256/RSA", "SHA-256/RSA", "SHA256withRSA"}, null, true, true, "SHA256withRSA");
        sha384WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.12", "sha384WithRSAEncryption", new String[]{"SHA384/RSA", "SHA-384/RSA", "SHA384withRSA"}, null, true, true, "SHA384withRSA");
        sha512WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.13", "sha512WithRSAEncryption", new String[]{"SHA512/RSA", "SHA-512/RSA", "SHA512withRSA"}, null, true, true, "SHA512withRSA");
        sha512_224WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.15", "sha512-224WithRSAEncryption", new String[]{"SHA512-224/RSA", "SHA512-224withRSA", "SHA512/224withRSA"}, null, true, true, "SHA512/224withRSA");
        sha512_256WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.16", "sha512-256WithRSAEncryption", new String[]{"SHA512-256/RSA", "SHA512-256withRSA", "SHA512/256withRSA"}, null, true, true, "SHA512/256withRSA");
        sha3_224WithRSAEncryption = new AlgorithmID("2.16.840.1.101.3.4.3.13", "sha3-224WithRSAEncryption", new String[]{"SHA3-224/RSA", "SHA3-224withRSA"}, null, true, true, "SHA3-224withRSA");
        sha3_256WithRSAEncryption = new AlgorithmID("2.16.840.1.101.3.4.3.14", "sha3-256WithRSAEncryption", new String[]{"SHA3-256/RSA", "SHA3-256withRSA"}, null, true, true, "SHA3-256withRSA");
        sha3_384WithRSAEncryption = new AlgorithmID("2.16.840.1.101.3.4.3.15", "sha3-384WithRSAEncryption", new String[]{"SHA3-384/RSA", "SHA3-384withRSA"}, null, true, true, "SHA3-384withRSA");
        sha3_512WithRSAEncryption = new AlgorithmID("2.16.840.1.101.3.4.3.16", "sha3-512WithRSAEncryption", new String[]{"SHA3-512/RSA", "SHA3-512withRSA"}, null, true, true, "SHA3-512withRSA");
        dsa_ = new AlgorithmID("1.3.14.3.2.12", "DSA", new String[]{"DSA"}, j == null ? (j = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : j, I, false, null);
        dsa = new AlgorithmID("1.2.840.10040.4.1", "DSA", "DSA", j == null ? (j = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : j, I);
        dsa_With_SHA1 = new AlgorithmID("1.3.14.3.2.13", "dsaWithSHA1", new String[]{"SHA-1/DSA"}, j == null ? (j = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : j, false, false, "SHA1withDSA");
        dsaWithSHA1 = dsaWithSHA = new AlgorithmID("1.2.840.10040.4.3", "dsaWithSHA", new String[]{"SHA-1/DSA", "SHA1/DSA", "SHA/DSA", "SHA1withDSA"}, j == null ? (j = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : j, false, true, "SHA1withDSA");
        dsaWithSHA1_ = new AlgorithmID("1.3.14.3.2.27", "dsaWithSHA1", new String[]{"SHA-1/DSA"}, j == null ? (j = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : j, false, false, "SHA1withDSA");
        dsaWithSHA224 = new AlgorithmID("2.16.840.1.101.3.4.3.1", "dsaWithSHA224", new String[]{"SHA224withDSA", "SHA-224/DSA", "SHA224/DSA"}, j == null ? (j = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : j, false, true, "SHA224withDSA");
        dsaWithSHA256 = new AlgorithmID("2.16.840.1.101.3.4.3.2", "dsaWithSHA256", new String[]{"SHA256withDSA", "SHA-256/DSA", "SHA256/DSA"}, j == null ? (j = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : j, false, true, "SHA256withDSA");
        dsaWithSHA384 = new AlgorithmID("2.16.840.1.101.3.4.3.3", "dsaWithSHA384", new String[]{"SHA384withDSA", "SHA-384/DSA", "SHA384/DSA"}, j == null ? (j = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : j, false, true, "SHA384withDSA");
        dsaWithSHA512 = new AlgorithmID("2.16.840.1.101.3.4.3.4", "dsaWithSHA512", new String[]{"SHA512withDSA", "SHA-512/DSA", "SHA512/DSA"}, j == null ? (j = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : j, false, true, "SHA512withDSA");
        dsaWithSHA3_224 = new AlgorithmID("2.16.840.1.101.3.4.3.5", "dsaWithSHA3-224", new String[]{"SHA3-224withDSA", "SHA3-224/DSA"}, j == null ? (j = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : j, false, true, "SHA3-224withDSA");
        dsaWithSHA3_256 = new AlgorithmID("2.16.840.1.101.3.4.3.6", "dsaWithSHA3-256", new String[]{"SHA3-256withDSA", "SHA3-256/DSA"}, j == null ? (j = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : j, false, true, "SHA3-256withDSA");
        dsaWithSHA3_384 = new AlgorithmID("2.16.840.1.101.3.4.3.7", "dsaWithSHA3-384", new String[]{"SHA3-384withDSA", "SHA3-384/DSA"}, j == null ? (j = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : j, false, true, "SHA3-384withDSA");
        dsaWithSHA3_512 = new AlgorithmID("2.16.840.1.101.3.4.3.8", "dsaWithSHA3-512", new String[]{"SHA3-512withDSA", "SHA3-512/DSA"}, j == null ? (j = AlgorithmID.class$("java.security.spec.DSAParameterSpec")) : j, false, true, "SHA3-512withDSA");
        rsaKem = new AlgorithmID("1.0.18033.2.2.4", "RsaKem", "RsaKem", k == null ? (k = AlgorithmID.class$("iaik.security.rsa.RsaKemAlgorithmParameterSpec")) : k);
        kdf1 = new AlgorithmID("1.0.18033.2.5.1", "kdf1", "KDF1", l == null ? (l = AlgorithmID.class$("iaik.security.kdf.KDF1ParameterSpec")) : l);
        kdf2 = new AlgorithmID("1.3.133.16.840.9.44.1.1", "kdf2", "KDF2", m == null ? (m = AlgorithmID.class$("iaik.security.kdf.KDF2ParameterSpec")) : m);
        kdf3 = new AlgorithmID("1.3.133.16.840.9.44.1.2", "kdf3", "KDF3", n == null ? (n = AlgorithmID.class$("iaik.security.kdf.KDF3ParameterSpec")) : n);
        ecPublicKey = ecdsa = new AlgorithmID("1.2.840.10045.2.1", "ECPublicKey", new String[]{"ECDSA", "EC"}, null, I, true, "EC");
        ecDH = new AlgorithmID("1.3.132.1.12", "ecDH", new String[]{"ECDH"}, null, I, true, "EC");
        dhSinglePass_stdDH_sha1kdf_scheme = new AlgorithmID("1.3.133.16.840.63.0.2", "dhSinglePass-stdDH-sha1kdf-scheme", "ECDH");
        dhSinglePass_stdDH_sha224kdf_scheme = new AlgorithmID("1.3.132.1.11.0", "dhSinglePass-stdDH-sha224kdf-scheme", "ECDH");
        dhSinglePass_stdDH_sha256kdf_scheme = new AlgorithmID("1.3.132.1.11.1", "dhSinglePass-stdDH-sha256kdf-scheme", "ECDH");
        dhSinglePass_stdDH_sha384kdf_scheme = new AlgorithmID("1.3.132.1.11.2", "dhSinglePass-stdDH-sha384kdf-scheme", "ECDH");
        dhSinglePass_stdDH_sha512kdf_scheme = new AlgorithmID("1.3.132.1.11.3", "dhSinglePass-stdDH-sha512kdf-scheme", "ECDH");
        dhSinglePass_cofactorDH_sha1kdf_scheme = new AlgorithmID("1.3.133.16.840.63.0.3", "dhSinglePass-cofactorDH-sha1kdf-scheme", "ECDHwithCofactor");
        dhSinglePass_cofactorDH_sha224kdf_scheme = new AlgorithmID("1.3.132.1.14.0", "dhSinglePass-cofactorDH-sha224kdf-scheme", "ECDHwithCofactor");
        dhSinglePass_cofactorDH_sha256kdf_scheme = new AlgorithmID("1.3.132.1.14.1", "dhSinglePass-cofactorDH-sha256kdf-scheme", "ECDHwithCofactor");
        dhSinglePass_cofactorDH_sha384kdf_scheme = new AlgorithmID("1.3.132.1.14.2", "dhSinglePass-cofactorDH-sha384kdf-scheme", "ECDHwithCofactor");
        dhSinglePass_cofactorDH_sha512kdf_scheme = new AlgorithmID("1.3.132.1.14.3", "dhSinglePass-cofactorDH-sha512kdf-scheme", "ECDHwithCofactor");
        dhSinglePass_stdDH_hkdf_sha256_scheme = new AlgorithmID("1.2.840.113549.1.9.16.3.19", "dhSinglePass-stdDH-hkdf-sha256-scheme", "ECDH");
        dhSinglePass_stdDH_hkdf_sha384_scheme = new AlgorithmID("1.2.840.113549.1.9.16.3.20", "dhSinglePass-stdDH-hkdf-sha384-scheme", "ECDH");
        dhSinglePass_stdDH_hkdf_sha512_scheme = new AlgorithmID("1.2.840.113549.1.9.16.3.21", "dhSinglePass-stdDH-hkdf-sha512-scheme", "ECDH");
        ecka_eg_X963KDF_SHA256 = new AlgorithmID("0.4.0.127.0.7.1.1.5.1.1.3", "ECKA-EG", "ECDH");
        ecka_eg_X963KDF_SHA384 = new AlgorithmID("0.4.0.127.0.7.1.1.5.1.1.4", "ECKA-EG", "ECDH");
        ecka_eg_X963KDF_SHA512 = new AlgorithmID("0.4.0.127.0.7.1.1.5.1.1.5", "ECKA-EG", "ECDH");
        x25519 = new AlgorithmID("1.3.101.110", "X25519", "X25519");
        x448 = new AlgorithmID("1.3.101.111", "X448", "X448");
        ed25519 = new AlgorithmID("1.3.101.112", "Ed25519", "Ed25519");
        ed448 = new AlgorithmID("1.3.101.113", "Ed448", "Ed448");
        hkdf_with_SHA256 = new AlgorithmID("1.2.840.113549.1.9.16.3.28", "hkdf-with-sha256", "HKDFwithSHA256", false);
        hkdf_with_SHA384 = new AlgorithmID("1.2.840.113549.1.9.16.3.29", "hkdf-with-sha384", "HKDFwithSHA384", false);
        hkdf_with_SHA512 = new AlgorithmID("1.2.840.113549.1.9.16.3.30", "hkdf-with-sha512", "HKDFwithSHA512", false);
        x9_63_kdf = new AlgorithmID("1.3.132.1.17.0", "x9-63-kdf", "X9.63-KDF", false);
        gost3410 = new AlgorithmID("1.2.643.2.2.19", "gostR3410-2001", "GOST3410", null, false);
        ecdsa_With_SHA1 = new AlgorithmID("1.2.840.10045.4.1", "ecdsaWithSHA1", new String[]{"SHA1withECDSA", "SHA1/ECDSA", "SHA-1/ECDSA"}, null, false);
        ecdsa_With_SHA224 = new AlgorithmID("1.2.840.10045.4.3.1", "ecdsaWithSHA224", new String[]{"SHA224withECDSA", "SHA224/ECDSA", "SHA-224/ECDSA"}, null, false);
        ecdsa_With_SHA256 = new AlgorithmID("1.2.840.10045.4.3.2", "ecdsaWithSHA256", new String[]{"SHA256withECDSA", "SHA256/ECDSA", "SHA-256/ECDSA"}, null, false);
        ecdsa_With_SHA384 = new AlgorithmID("1.2.840.10045.4.3.3", "ecdsaWithSHA384", new String[]{"SHA384withECDSA", "SHA384/ECDSA", "SHA-384/ECDSA"}, null, false);
        ecdsa_With_SHA512 = new AlgorithmID("1.2.840.10045.4.3.4", "ecdsaWithSHA512", new String[]{"SHA512withECDSA", "SHA512/ECDSA", "SHA-512/ECDSA"}, null, false);
        ecdsa_With_SHA3_224 = new AlgorithmID("2.16.840.1.101.3.4.3.9", "ecdsaWithSHA3-224", new String[]{"SHA3-224withECDSA", "SHA3-224/ECDSA"}, null, false);
        ecdsa_With_SHA3_256 = new AlgorithmID("2.16.840.1.101.3.4.3.10", "ecdsaWithSHA3-256", new String[]{"SHA3-256withECDSA", "SHA3-256/ECDSA"}, null, false);
        ecdsa_With_SHA3_384 = new AlgorithmID("2.16.840.1.101.3.4.3.11", "ecdsaWithSHA3-384", new String[]{"SHA3-384withECDSA", "SHA3-384/ECDSA"}, null, false);
        ecdsa_With_SHA3_512 = new AlgorithmID("2.16.840.1.101.3.4.3.12", "ecdsaWithSHA3-512", new String[]{"SHA3-512withECDSA", "SHA3-512/ECDSA"}, null, false);
        ecdsa_plain_With_SHA1 = new AlgorithmID("0.4.0.127.0.7.1.1.4.1.1", "ecdsaPlainWithSHA1", "SHA1withECDSAPlain", null, false);
        ecdsa_plain_With_SHA224 = new AlgorithmID("0.4.0.127.0.7.1.1.4.1.2", "ecdsaPlainWithSHA224", "SHA224withECDSAPlain", null, false);
        ecdsa_plain_With_SHA256 = new AlgorithmID("0.4.0.127.0.7.1.1.4.1.3", "ecdsaPlainWithSHA256", "SHA256withECDSAPlain", null, false);
        ecdsa_plain_With_SHA384 = new AlgorithmID("0.4.0.127.0.7.1.1.4.1.4", "ecdsaPlainWithSHA384", "SHA384withECDSAPlain", null, false);
        ecdsa_plain_With_SHA512 = new AlgorithmID("0.4.0.127.0.7.1.1.4.1.5", "ecdsaPlainWithSHA512", "SHA512withECDSAPlain", null, false);
        ecdsa_plain_With_RIPEMD160 = new AlgorithmID("0.4.0.127.0.7.1.1.4.1.6", "ecdsaPlainWithRIPEMD160", "RIPEMD160withECDSAPlain", null, false);
        rsaSignatureWithRipemd160 = new AlgorithmID("1.3.36.3.3.1.2", "rsaSignatureWithRipemd160", new String[]{"RIPEMD160/RSA", "RIPEMD160withRSA", "RipeMd160withRSA"}, null, I, true, "RIPEMD160withRSA");
        rsaSignatureWithRipemd128 = new AlgorithmID("1.3.36.3.3.1.3", "rsaSignatureWithRipemd128", new String[]{"RIPEMD128/RSA", "RIPEMD128withRSA", "RipeMd128withRSA"}, null, I, true, "RIPEMD128withRSA");
        rsaSignatureWithRipemd256 = new AlgorithmID("1.3.36.3.3.1.4", "rsaSignatureWithRipemd256", new String[]{"RIPEMD256/RSA", "RIPEMD256withRSA", "RipeMd256withRSA"}, null, I, true, "RIPEMD256withRSA");
        sigS_ISO9796_2Withrsa = new AlgorithmID("1.3.36.3.4.2.2", "RSA-ISO9796-2-2-3", "RSA-ISO9796-2-2-3", null, I);
        sigS_ISO9796_2Withsha1 = new AlgorithmID("1.3.36.3.4.2.2.1", "SHA1andMGF1/RSA-ISO9796-2-2-3", new String[]{"SHA1andMGF1/RSA-ISO9796-2-2-3", "SHAandMGF1/RSA-ISO9796-2-2-3"}, null, I);
        sigS_ISO9796_2Withripemd160 = new AlgorithmID("1.3.36.3.4.2.2.2", "RSA-ISO9796_2Withripemd160", "RIPEMD160andMGF1/RSA-ISO9796-2-2-3", null, I);
        sigS_ISO9796_2rndWithrsa = new AlgorithmID("1.3.36.3.4.2.3", "RSA-ISO9796-2-2-3", "RSA-ISO9796-2-2-3", null, I);
        sigS_ISO9796_2rndWithsha1 = new AlgorithmID("1.3.36.3.4.2.3.1", "SHAandMGF1/RSA-ISO9796-2-2-3", "SHAandMGF1/RSA-ISO9796-2-2-3", null, I);
        sigS_ISO9796_2rndWithripemd160 = new AlgorithmID("1.3.36.3.4.2.3.2", "RSA-ISO9796_2Withripemd160", "RIPEMD160andMGF1/RSA-ISO9796-2-2-3", null, I);
        mgf1 = new AlgorithmID("1.2.840.113549.1.1.8", "MGF1", "MGF1", o == null ? (o = AlgorithmID.class$("iaik.pkcs.pkcs1.MGF1ParameterSpec")) : o, "java.security.spec.MGF1ParameterSpec", I);
        pbeWithMD5AndDES_CBC = new AlgorithmID("1.2.840.113549.1.5.3", "PbeWithMD5AndDES-CBC", new String[]{"PbeWithMD5AndDES_CBC", "PBEWithMD5AndDES"}, p == null ? (p = AlgorithmID.class$("javax.crypto.spec.PBEParameterSpec")) : p, I, true, "PBEWithMD5AndDES");
        pbeWithSHAAnd128BitRC4 = new AlgorithmID("1.2.840.113549.1.12.1.1", "PbeWithSHAAnd128BitRC4", "PBEWithSHA1AndPC4_128", p == null ? (p = AlgorithmID.class$("javax.crypto.spec.PBEParameterSpec")) : p, I);
        pbeWithSHAAnd40BitRC4 = new AlgorithmID("1.2.840.113549.1.12.1.2", "PbeWithSHAAnd40BitRC4", "PBEWithSHA1AndRC4_40", p == null ? (p = AlgorithmID.class$("javax.crypto.spec.PBEParameterSpec")) : p, I);
        pbeWithSHAAnd3_KeyTripleDES_CBC = new AlgorithmID("1.2.840.113549.1.12.1.3", "PbeWithSHAAnd3-KeyTripleDES-CBC", new String[]{"PbeWithSHAAnd3_KeyTripleDES_CBC", "PBEWithSHA1AndDESede"}, p == null ? (p = AlgorithmID.class$("javax.crypto.spec.PBEParameterSpec")) : p, I, true, "PBEWithSHA1AndDESede");
        pbeWithSHAAnd2_KeyTripleDES_CBC = new AlgorithmID("1.2.840.113549.1.12.1.4", "PbeWithSHAAnd2-KeyTripleDES-CBC", (String)null, p == null ? (p = AlgorithmID.class$("javax.crypto.spec.PBEParameterSpec")) : p, I);
        pbeWithSHAAnd128BitRC2_CBC = new AlgorithmID("1.2.840.113549.1.12.1.5", "PbeWithSHAAnd128BitRC2-CBC", "PBEWithSHA1AndRC2_128", p == null ? (p = AlgorithmID.class$("javax.crypto.spec.PBEParameterSpec")) : p, I);
        pbeWithSHAAnd40BitRC2_CBC = new AlgorithmID("1.2.840.113549.1.12.1.6", "PbeWithSHAAnd40BitRC2-CBC", new String[]{"PbeWithSHAAnd40BitRC2_CBC", "PBEWithSHA1AndRC2_40"}, p == null ? (p = AlgorithmID.class$("javax.crypto.spec.PBEParameterSpec")) : p, I, true, "PBEWithSHA1AndRC2_40");
        pbkdf2 = new AlgorithmID("1.2.840.113549.1.5.12", "PBKDF2", "PBKDF2", q == null ? (q = AlgorithmID.class$("iaik.pkcs.pkcs5.PBKDF2ParameterSpec")) : q, I);
        pbes2 = new AlgorithmID("1.2.840.113549.1.5.13", "PBES2", "PBES2", r == null ? (r = AlgorithmID.class$("iaik.pkcs.pkcs5.PBES2ParameterSpec")) : r, I);
        pbmac1 = new AlgorithmID("1.2.840.113549.1.5.14", "PBMAC1", "PBMAC1", s == null ? (s = AlgorithmID.class$("iaik.pkcs.pkcs5.PBMAC1ParameterSpec")) : s, I);
        pSpecified = new AlgorithmID("1.2.840.113549.1.1.9", "pSpecified", "pSpecified", null, I);
        md2 = new AlgorithmID("1.2.840.113549.2.2", "MD2", "MD2", null, I);
        md4 = new AlgorithmID("1.2.840.113549.2.4", "MD4", (String)null, null, I);
        md5 = new AlgorithmID("1.2.840.113549.2.5", "MD5", "MD5", null, I);
        sha1 = sha = new AlgorithmID("1.3.14.3.2.26", "SHA1", new String[]{"SHA1", "SHA-1", "SHA"}, null, I, true, "SHA-1");
        gost3411 = new AlgorithmID("1.2.643.2.2.9", "GOST-R-34.11-94", "GOST3411", null, I);
        sha256 = new AlgorithmID("2.16.840.1.101.3.4.2.1", "SHA256", new String[]{"SHA256", "SHA-256"}, null, I, true, "SHA-256");
        sha224 = new AlgorithmID("2.16.840.1.101.3.4.2.4", "SHA224", new String[]{"SHA224", "SHA-224"}, null, I, true, "SHA-224");
        sha384 = new AlgorithmID("2.16.840.1.101.3.4.2.2", "SHA384", new String[]{"SHA384", "SHA-384"}, null, I, true, "SHA-384");
        sha512 = new AlgorithmID("2.16.840.1.101.3.4.2.3", "SHA512", new String[]{"SHA512", "SHA-512"}, null, I, true, "SHA-512");
        sha512_224 = new AlgorithmID("2.16.840.1.101.3.4.2.5", "SHA512/224", new String[]{"SHA512/224", "SHA-512/224"}, null, I, true, "SHA-512/224");
        sha512_256 = new AlgorithmID("2.16.840.1.101.3.4.2.6", "SHA512/256", new String[]{"SHA512/256", "SHA-512/256"}, null, I, true, "SHA-512/256");
        sha3_224 = new AlgorithmID("2.16.840.1.101.3.4.2.7", "SHA3-224", new String[]{"SHA3-224"}, null, I);
        sha3_256 = new AlgorithmID("2.16.840.1.101.3.4.2.8", "SHA3-256", new String[]{"SHA3-256"}, null, I);
        sha3_384 = new AlgorithmID("2.16.840.1.101.3.4.2.9", "SHA3-384", new String[]{"SHA3-384"}, null, I);
        sha3_512 = new AlgorithmID("2.16.840.1.101.3.4.2.10", "SHA3-512", new String[]{"SHA3-512"}, null, I);
        shake128 = new AlgorithmID("2.16.840.1.101.3.4.2.11", "SHAKE128", new String[]{"SHAKE128", "SHAKE-128"}, null, false, true, "SHAKE-128");
        shake256 = new AlgorithmID("2.16.840.1.101.3.4.2.12", "SHAKE256", new String[]{"SHAKE256", "SHAKE-256"}, null, false, true, "SHAKE-256");
        shake128Len = new AlgorithmID("2.16.840.1.101.3.4.2.17", "SHAKE128-LEN", new String[]{"SHAKE128", "SHAKE-128"}, null, false, false, "SHAKE-128");
        shake256Len = new AlgorithmID("2.16.840.1.101.3.4.2.18", "SHAKE256-LEN", new String[]{"SHAKE256", "SHAKE-256"}, null, false, false, "SHAKE-256");
        ripeMd160_ISO = new AlgorithmID("1.0.10118.3.0.49", "RipeMd160", new String[]{"RIPEMD160"}, null, I, false, "RIPEMD-160");
        ripeMd128_ISO = new AlgorithmID("1.0.10118.3.0.50", "RipeMd128", new String[]{"RIPEMD128"}, null, I, false, "RIPEMD-128");
        ripeMd160 = new AlgorithmID("1.3.36.3.2.1", "RipeMd160", new String[]{"RIPEMD160", "RipeMd160", "RIPEMD-160"}, null, I, true, "RIPEMD-160");
        ripeMd128 = new AlgorithmID("1.3.36.3.2.2", "RipeMd128", new String[]{"RIPEMD128", "RipeMd128", "RIPEMD-128"}, null, I, true, "RIPEMD-128");
        ripeMd256 = new AlgorithmID("1.3.36.3.2.3", "RipeMd256", new String[]{"RIPEMD256", "RIPEMD-256"}, null, I, true, "RIPEMD-256");
        whirlpool = new AlgorithmID("1.0.10118.3.0.55", "Whirlpool", new String[]{"WHIRLPOOL", "Whirlpool"}, null, I);
        hMAC_GOST = new AlgorithmID("1.2.643.2.2.10", "HMAC_GOSTR3411", new String[]{"HMAC/GOST", "HmacGOST"}, null, I, true, "HmacGOST");
        hMAC_MD5 = new AlgorithmID("1.3.6.1.5.5.8.1.1", "hMAC-MD5", new String[]{"HMAC/MD5", "HmacMD5"}, null, I, true, "HmacMD5");
        hMAC_SHA1_ = new AlgorithmID("1.2.840.113549.2.7", "hMAC-SHA1", new String[]{"HMAC/SHA1"}, null, I, false, "HmacSHA1");
        hMAC_SHA1 = new AlgorithmID("1.3.6.1.5.5.8.1.2", "hMAC-SHA1", new String[]{"HMAC/SHA1", "HMAC/SHA-1", "HmacSHA1"}, null, I, true, "HmacSHA1");
        hMAC_SHA224 = new AlgorithmID("1.2.840.113549.2.8", "hMAC-SHA224", new String[]{"HMAC/SHA224", "HMAC/SHA-224", "HmacSHA224"}, null, I, true, "HmacSHA224");
        hMAC_SHA256 = new AlgorithmID("1.2.840.113549.2.9", "hMAC-SHA256", new String[]{"HMAC/SHA256", "HMAC/SHA-256", "HmacSHA256"}, null, I, true, "HmacSHA256");
        hMAC_SHA384 = new AlgorithmID("1.2.840.113549.2.10", "hMAC-SHA384", new String[]{"HMAC/SHA384", "HMAC/SHA-384", "HmacSHA384"}, null, I, true, "HmacSHA384");
        hMAC_SHA512 = new AlgorithmID("1.2.840.113549.2.11", "hMAC-SHA512", new String[]{"HMAC/SHA512", "HMAC/SHA-512", "HmacSHA512"}, null, I, true, "HmacSHA512");
        hMAC_SHA3_224 = new AlgorithmID("2.16.840.1.101.3.4.2.13", "hMAC-SHA3-224", new String[]{"HMAC/SHA3-224", "HmacSHA3-224"}, null, I, true, "HmacSHA3-224");
        hMAC_SHA3_256 = new AlgorithmID("2.16.840.1.101.3.4.2.14", "hMAC-SHA3-256", new String[]{"HMAC/SHA3-256", "HmacSHA3-256"}, null, I, true, "HmacSHA3-256");
        hMAC_SHA3_384 = new AlgorithmID("2.16.840.1.101.3.4.2.15", "hMAC-SHA3-384", new String[]{"HMAC/SHA3-384", "HmacSHA3-384"}, null, I, true, "HmacSHA3-384");
        hMAC_SHA3_512 = new AlgorithmID("2.16.840.1.101.3.4.2.16", "hMAC-SHA3-512", new String[]{"HMAC/SHA3-512", "HmacSHA3-512"}, null, I, true, "HmacSHA3-512");
        hMAC_RIPEMD160 = new AlgorithmID("1.3.6.1.5.5.8.1.4", "hMAC-RIPEMD160", new String[]{"HMAC/RIPEMD160", "HmacRIPEMD160"}, null, I, true, "HmacRIPEMD160");
        cms_3DES_wrap = new AlgorithmID("1.2.840.113549.1.9.16.3.6", "CMS-3DES-Wrap", new String[]{"3DESWrap3DES", "DESedeWrapDESede", "DESedeWrap"}, null, true, true, "DESedeWrap");
        cms_rc2_wrap = new AlgorithmID("1.2.840.113549.1.9.16.3.7", "CMS-RC2-Wrap", new String[]{"RC2WrapRC2", "RC2Wrap"}, null, I, true, "RC2Wrap");
        cms_idea_wrap = new AlgorithmID("1.3.6.1.4.1.188.7.1.1.6", "CMS-IDEA-Wrap", new String[]{"IDEAWrapIDEA", "IDEAWrap"}, null, true, true, "IDEAWrap");
        cms_cast5_wrap = new AlgorithmID("1.2.840.113533.7.66.15", "CMS-CAST128-Wrap", new String[]{"CAST128WrapCAST128", "CAST128Wrap"}, null, I, true, "CAST128Wrap");
        cms_aes128_wrap = new AlgorithmID("2.16.840.1.101.3.4.1.5", "CMS-AES128-Wrap", new String[]{"AESWrapAES", "AESWrap", "AES128Wrap", "AESWrap_128"}, null, false, true, "AESWrap");
        cms_aes192_wrap = new AlgorithmID("2.16.840.1.101.3.4.1.25", "CMS-AES192-Wrap", new String[]{"AES192WrapAES192", "AES192Wrap", "AESWrap_192"}, null, false, true, "AESWrap_192");
        cms_aes256_wrap = new AlgorithmID("2.16.840.1.101.3.4.1.45", "CMS-AES256-Wrap", new String[]{"AES256WrapAES256", "AES256Wrap", "AESWrap_256"}, null, false, true, "AESWrap_256");
        aes128_wrap_pad = new AlgorithmID("2.16.840.1.101.3.4.1.8", "AES128-Wrap-Pad", new String[]{"AESWrapWithPadding", "AES128WrapWithPadding", "AESRFC5649Wrap", "AES128RFC5649Wrap", "AESRFC5649Wrap_128"}, null, false, true, "AESWrapWithPadding");
        aes192_wrap_pad = new AlgorithmID("2.16.840.1.101.3.4.1.28", "AES192-Wrap-Pad", new String[]{"AES192WrapWithPadding", "AES192RFC5649Wrap", "AESRFC5649Wrap_192"}, null, false, true, "AES192WrapWithPadding");
        aes256_wrap_pad = new AlgorithmID("2.16.840.1.101.3.4.1.48", "AES256-Wrap-Pad", new String[]{"AES256WrapWithPadding", "AES256RFC5649Wrap", "AESRFC5649Wrap_256"}, null, false, true, "AES256WrapWithPadding");
        cms_camellia128_wrap = new AlgorithmID("1.2.392.200011.61.1.1.3.2", "CMS-Camellia128-Wrap", new String[]{"CamelliaWrapCamellia", "CamelliaWrap", "Camellia128Wrap", "CamelliaWrap_128"}, null, false, true, "CamelliaWrap");
        cms_camellia192_wrap = new AlgorithmID("1.2.392.200011.61.1.1.3.3", "CMS-Camellia192-Wrap", new String[]{"Camellia192WrapCamellia192", "Camellia192Wrap", "CamelliaWrap_192"}, null, false, true, "CamelliaWrap_192");
        cms_camellia256_wrap = new AlgorithmID("1.2.392.200011.61.1.1.3.4", "CMS-Camellia256-Wrap", new String[]{"Camellia256WrapCamellia256", "Camellia256Wrap", "CamelliaWrap_256"}, null, false, true, "CamelliaWrap_256");
        cms_HMACwith3DES_wrap = new AlgorithmID("1.2.840.113549.1.9.16.3.11", "CMS-HMACwith3DES-Wrap", "3DESWrapHMAC", null, true);
        cms_HMACwithAES_wrap = new AlgorithmID("1.2.840.113549.1.9.16.3.12", "CMS-HMACwithAES-Wrap", "AESWrapHMAC", null, true);
        pwri_kek = new AlgorithmID("1.2.840.113549.1.9.16.3.9", "PWRI-KEK", "PWRI-KEK", null, I);
        zlib_compress = new AlgorithmID("1.2.840.113549.1.9.16.3.8", "ZLIB-COMPRESS", "ZLIB-COMPRESS", null, I);
        rsaesOAEP = new AlgorithmID("1.2.840.113549.1.1.7", "RSAES-OAEP", "RSA/ECB/OAEP", t == null ? (t = AlgorithmID.class$("iaik.pkcs.pkcs1.RSAOaepParameterSpec")) : t, "javax.crypto.spec.OAEPParameterSpec", false);
        rsassaPss = new AlgorithmID("1.2.840.113549.1.1.10", "RSASSA-PSS", "RSASSA-PSS", u == null ? (u = AlgorithmID.class$("iaik.pkcs.pkcs1.RSAPssParameterSpec")) : u, "java.security.spec.PSSParameterSpec", false);
        O.put(dsa_With_SHA1, dsa_With_SHA1);
        O.put(dsaWithSHA, dsaWithSHA);
        O.put(dsaWithSHA1, dsaWithSHA1);
        O.put(dsa, dsa);
        O.put(dsa_, dsa_);
        O.put(dsaWithSHA224, dsaWithSHA224);
        O.put(dsaWithSHA256, dsaWithSHA256);
        O.put(dsaWithSHA384, dsaWithSHA384);
        O.put(dsaWithSHA512, dsaWithSHA512);
        O.put(dsaWithSHA3_224, dsaWithSHA3_224);
        O.put(dsaWithSHA3_256, dsaWithSHA3_256);
        O.put(dsaWithSHA3_384, dsaWithSHA3_384);
        O.put(dsaWithSHA3_512, dsaWithSHA3_512);
        O.put(ecdsa_With_SHA1, ecdsa_With_SHA1);
        O.put(ecdsa_With_SHA224, ecdsa_With_SHA224);
        O.put(ecdsa_With_SHA256, ecdsa_With_SHA256);
        O.put(ecdsa_With_SHA384, ecdsa_With_SHA384);
        O.put(ecdsa_With_SHA512, ecdsa_With_SHA512);
        O.put(ecdsa_With_SHA3_224, ecdsa_With_SHA3_224);
        O.put(ecdsa_With_SHA3_256, ecdsa_With_SHA3_256);
        O.put(ecdsa_With_SHA3_384, ecdsa_With_SHA3_384);
        O.put(ecdsa_With_SHA3_512, ecdsa_With_SHA3_512);
        O.put(ecdsa, ecdsa);
        O.put(ecdsa_plain_With_RIPEMD160, ecdsa_plain_With_RIPEMD160);
        O.put(ecdsa_plain_With_SHA1, ecdsa_plain_With_SHA1);
        O.put(ecdsa_plain_With_SHA224, ecdsa_plain_With_SHA224);
        O.put(ecdsa_plain_With_SHA256, ecdsa_plain_With_SHA256);
        O.put(ecdsa_plain_With_SHA384, ecdsa_plain_With_SHA384);
        O.put(ecdsa_plain_With_SHA512, ecdsa_plain_With_SHA512);
    }
}

