/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GeneralizedTime
extends ASN1Object {
    String a = null;

    protected GeneralizedTime() {
        this.asnType = ASN.GeneralizedTime;
    }

    public GeneralizedTime(String string) {
        this();
        this.a = string;
    }

    public GeneralizedTime(String string, boolean bl) throws IllegalArgumentException {
        this();
        if (bl) {
            try {
                this.a(string, true);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        }
        this.a = string;
    }

    public Object getValue() {
        return this.a;
    }

    public void setValue(Object object) {
        this.a = (String)object;
    }

    protected void encode(OutputStream outputStream) throws IOException {
        outputStream.write(Util.toASCIIBytes(this.a));
    }

    protected void decode(int n2, InputStream inputStream) throws IOException {
        try {
            byte[] byArray = new byte[n2];
            Util.fillArray(byArray, inputStream);
            this.a = Util.toASCIIString(byArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Invalid GenerailzedTime encoding! Not enough memory for decoding value!");
        }
        if (this.c) {
            this.a(this.a, false);
        }
    }

    private void a(String string, boolean bl) throws IOException {
        if (!string.endsWith("Z")) {
            throw new IOException("Invalid DER encoded GeneralizedTime. Missing terminating Z!");
        }
        if (string.length() < 15) {
            throw new IOException("Invalid DER encoded GeneralizedTime. Missing seconds!");
        }
        if (string.substring(8, 10).equals("24")) {
            throw new IOException("Invalid DER encoded GeneralizedTime. Incorrect midnight representation!");
        }
        int n2 = string.indexOf(".");
        if (n2 != -1) {
            boolean bl2 = true;
            int n3 = n2 + 1;
            char c2 = string.charAt(n3);
            if (c2 == 'Z') {
                throw new IOException("Invalid DER encoded GeneralizedTime. Incorrect fractional-seconds representation!");
            }
            int n4 = string.length() - 1;
            do {
                bl2 = (c2 = string.charAt(n3)) != '0';
            } while (++n3 < n4);
            if (!bl2) {
                throw new IOException("Invalid DER encoded GeneralizedTime. Incorrect fractional-seconds representation!");
            }
        }
        if (bl) {
            try {
                ChoiceOfTime choiceOfTime = new ChoiceOfTime(string, ASN.GeneralizedTime);
                choiceOfTime.getDate();
            }
            catch (Exception exception) {
                throw new IOException("Invalid DER formatted UTCTime: " + exception.getMessage());
            }
        }
    }

    public String toString() {
        return super.toString() + this.a;
    }
}

