/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1String;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BIT_STRING
extends ASN1Object {
    protected int bits_not_valid;
    protected byte[] value;

    protected BIT_STRING() {
        this.asnType = ASN.BIT_STRING;
        this.bits_not_valid = 0;
    }

    public BIT_STRING(byte[] byArray, int n2) {
        this();
        if (n2 < -1 || n2 > 7) {
            throw new IllegalArgumentException("bitsNotValid (" + n2 + ") out of range! " + "Must be between -1 and 7");
        }
        this.value = byArray;
        if (n2 == -1) {
            int n3;
            int n4 = 0;
            for (n3 = this.value.length; n3 > 0 && this.value[n3 - 1] == 0; --n3) {
            }
            if (n3 > 0) {
                int n5 = this.value[n3 - 1] & 0xFF;
                while ((n5 & 1) == 0) {
                    n5 >>= 1;
                    ++n4;
                }
            }
            this.bits_not_valid = n4;
        } else {
            this.bits_not_valid = n2;
        }
    }

    public BIT_STRING(byte[] byArray) {
        this();
        this.value = byArray;
        this.bits_not_valid = 0;
    }

    public BIT_STRING(String string) {
        this();
        int n2;
        int n3 = string.length();
        this.bits_not_valid = (8 - n3 % 8) % 8;
        int n4 = (n3 + 7) / 8;
        this.value = new byte[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            int n5 = n2 / 8;
            this.value[n5] = (byte)(this.value[n5] << 1);
            if (string.charAt(n2) != '1') continue;
            int n6 = n2 / 8;
            this.value[n6] = (byte)(this.value[n6] + 1);
        }
        if (this.bits_not_valid > 0) {
            int n7 = n2 / 8;
            this.value[n7] = (byte)(this.value[n7] << this.bits_not_valid);
        }
    }

    public BIT_STRING(boolean[] blArray) {
        this();
        int n2;
        int n3 = blArray.length;
        this.bits_not_valid = 8 - n3 % 8;
        this.value = new byte[(n3 + 7) / 8];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = n2 / 8;
            this.value[n4] = (byte)(this.value[n4] << 1);
            if (!blArray[n2]) continue;
            int n5 = n2 / 8;
            this.value[n5] = (byte)(this.value[n5] + 1);
        }
        if (this.bits_not_valid > 0) {
            int n6 = n2 / 8;
            this.value[n6] = (byte)(this.value[n6] << this.bits_not_valid);
        }
    }

    public Object clone() {
        BIT_STRING bIT_STRING = (BIT_STRING)super.clone();
        if (this.value != null) {
            bIT_STRING.value = (byte[])this.value.clone();
        }
        bIT_STRING.bits_not_valid = this.bits_not_valid;
        return bIT_STRING;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = (byte[])object;
        this.bits_not_valid = 0;
    }

    public int bitsNotValid() {
        return this.bits_not_valid;
    }

    public String getBinaryString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.value.length > 0) {
            int n2;
            int n3;
            for (n3 = 0; n3 < this.value.length - 1; ++n3) {
                for (n2 = 7; n2 >= 0; --n2) {
                    if ((this.value[n3] & 1 << n2) != 0) {
                        stringBuffer.append('1');
                        continue;
                    }
                    stringBuffer.append('0');
                }
            }
            if (this.bits_not_valid >= 0) {
                for (n2 = 7; n2 >= this.bits_not_valid; --n2) {
                    if ((this.value[n3] & 1 << n2) != 0) {
                        stringBuffer.append('1');
                        continue;
                    }
                    stringBuffer.append('0');
                }
            }
        }
        String string = stringBuffer.toString();
        return string;
    }

    protected void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.value);
        outputStream.write(this.bits_not_valid);
    }

    protected void decode(int n2, InputStream inputStream) throws IOException {
        if (this.constructed && (this.c || !ASN1String.a())) {
            throw new IOException("Constructed encoding for BIT_STRING not supported!");
        }
        try {
            this.bits_not_valid = inputStream.read();
            this.value = new byte[n2 - 1];
            Util.fillArray(this.value, inputStream);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Not enough memory for decoding ASN.1 BIT STRING value!");
        }
        if (this.c && this.value.length > 0 && this.bits_not_valid > 0) {
            try {
                int n3;
                byte by = this.value[this.value.length - 1];
                for (int i2 = n3 = this.bits_not_valid - 1; i2 >= 0; --i2) {
                    if ((by & 1 << i2) == 0) continue;
                    throw new IOException("Invalid DER encoed BIT_STRING. Found non-zero unused bit!");
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return super.toString() + this.value.length + " byte(s); " + this.bits_not_valid + " bit(s) not valid";
    }
}

