/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.EncodeListener;
import iaik.asn1.d;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ASN1Object
implements Cloneable {
    protected boolean constructed = false;
    protected boolean indefinite_length = false;
    protected ASN asnType;
    protected boolean isStringType = false;
    protected d[] encode_listener;
    protected boolean stream_mode = false;
    boolean c = false;

    protected ASN1Object() {
    }

    public Object clone() {
        ASN1Object aSN1Object = null;
        try {
            aSN1Object = (ASN1Object)super.clone();
            if (this.encode_listener != null) {
                aSN1Object.encode_listener = (d[])this.encode_listener.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return aSN1Object;
    }

    public ASN getAsnType() {
        return this.asnType;
    }

    public boolean indefiniteLength() {
        return this.indefinite_length;
    }

    public void setIndefiniteLength(boolean bl) {
        this.indefinite_length = bl;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public void addEncodeListener(EncodeListener encodeListener, int n2) {
        d d2 = new d(encodeListener, n2, -1);
        if (this.encode_listener == null) {
            this.encode_listener = new d[]{d2};
            return;
        }
        this.encode_listener = (d[])Util.resizeArray(this.encode_listener, this.encode_listener.length + 1);
        this.encode_listener[this.encode_listener.length - 1] = d2;
    }

    protected void encodeObject(OutputStream outputStream, boolean bl) throws IOException {
        if (this.encode_listener != null) {
            try {
                d d2 = null;
                for (int i2 = 0; i2 < this.encode_listener.length; ++i2) {
                    d2 = this.encode_listener[i2];
                    if (d2.c() != -1) continue;
                    d2.a().encodeCalled(this, d2.b());
                }
            }
            catch (CodingException codingException) {
                throw new IOException("Error from EncodeListener: " + codingException.getMessage());
            }
        }
        this.stream_mode = bl;
        this.encode(outputStream);
    }

    public boolean isA(ASN aSN) {
        if (aSN.equals(ASN.CON_SPEC)) {
            return this instanceof CON_SPEC;
        }
        return this.asnType.equals(aSN);
    }

    public ASN1Object getComponentAt(int n2) throws CodingException {
        throw new CodingException("ASN1: " + this.asnType.getName() + " does not support getComponentAt(int)!");
    }

    public int countComponents() throws CodingException {
        throw new CodingException("ASN1: " + this.asnType.getName() + " does not support countComponents()!");
    }

    public void addComponent(ASN1Object aSN1Object) throws CodingException {
        throw new CodingException("ASN1: " + this.asnType.getName() + " does not support addComponent()!");
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    protected abstract void encode(OutputStream var1) throws IOException;

    protected abstract void decode(int var1, InputStream var2) throws CodingException, IOException;

    public boolean isStringType() {
        return this.isStringType;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.asnType.getName());
        if (this.constructed) {
            stringBuffer.append("[C]");
        }
        if (this.indefinite_length) {
            stringBuffer.append("[I]");
        }
        stringBuffer.append(" = ");
        return stringBuffer.toString();
    }

    static {
        Util.toString(null, -1, 1);
    }
}

