/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.security.md.Md5;
import iaik.utils.Base64InputStream;
import iaik.utils.CryptoUtils;
import iaik.utils.TracedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;

public class ASN1
implements Cloneable {
    public static final int DER = 1;
    public static final int PEM = 2;
    public static final String startLine = "-----BEGIN";
    private static final byte[] a = new byte[]{45, 45, 45, 45, 45, 66, 69, 71, 73, 78};
    private ASN1Object b;
    private byte[] c;
    private int d = 1;

    public static byte[] readEncoded(InputStream inputStream) throws IOException, CodingException {
        ASN1 aSN1 = new ASN1(inputStream, false);
        return aSN1.toByteArray();
    }

    public ASN1() {
    }

    public ASN1(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new CodingException("Cannot parse an ASN1 object from a null object.");
        }
        this.b = aSN1Object;
    }

    public ASN1(InputStream inputStream) throws IOException, CodingException {
        this(inputStream, true);
    }

    ASN1(InputStream inputStream, boolean bl) throws IOException, CodingException {
        if (inputStream == null) {
            throw new IOException("Cannot parse an ASN1 object from a null input stream!");
        }
        this.a(inputStream, bl);
    }

    public ASN1(byte[] byArray) throws CodingException {
        if (byArray == null) {
            throw new CodingException("Cannot parse an ASN1 object from a null byte array!");
        }
        try {
            this.a(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new CodingException(this, iOException.getMessage(), iOException){
                private static final long serialVersionUID = -5532766842768993177L;
                private final IOException a;
                private final ASN1 b;
                {
                    this.b = aSN1;
                    this.a = iOException;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
    }

    private void a(InputStream inputStream) throws CodingException, IOException {
        this.a(inputStream, true);
    }

    private void a(InputStream inputStream, boolean bl) throws CodingException, IOException {
        FilterInputStream filterInputStream;
        int n2;
        boolean bl2;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 20);
        byte[] byArray = new byte[10];
        int n3 = -1;
        int n4 = pushbackInputStream.read(byArray);
        if (n4 == -1) {
            throw new EOFException();
        }
        if (n4 >= 6) {
            n3 = ASN1.a(byArray);
        }
        if (bl2 = CryptoUtils.equalsBlock(byArray, a)) {
            while ((n2 = pushbackInputStream.read()) != 13 && n2 != 10 && n2 != -1) {
            }
            if (n2 == -1) {
                throw new IOException("Unexpected EOF in encoding!");
            }
            if (n2 == 13) {
                pushbackInputStream.read();
            }
            this.d = 2;
            filterInputStream = new Base64InputStream(pushbackInputStream);
            ((Base64InputStream)filterInputStream).setIgnoreInvalidCharacters(true);
        } else {
            pushbackInputStream.unread(byArray, 0, n4);
            n2 = pushbackInputStream.read();
            pushbackInputStream.unread(n2);
            if (n2 >= 65 && n2 <= 77 || n2 >= 103 && n2 <= 122) {
                this.d = 2;
                filterInputStream = new Base64InputStream(pushbackInputStream);
                ((Base64InputStream)filterInputStream).setIgnoreInvalidCharacters(true);
            } else {
                this.d = 1;
                filterInputStream = pushbackInputStream;
            }
        }
        TracedInputStream tracedInputStream = new TracedInputStream(filterInputStream, n3);
        this.b = DerCoder.a(tracedInputStream, bl, false);
        this.c = tracedInputStream.getTracedData();
        if (!bl) {
            this.b = null;
        }
        if (bl2) {
            pushbackInputStream.skip(10L);
            while ((n2 = pushbackInputStream.read()) != 13 && n2 != 10 && n2 != -1) {
            }
            if (n2 == 13) {
                pushbackInputStream.read();
            }
        }
    }

    private static int a(byte[] byArray) {
        int n2 = byArray[0] & 0xFF;
        if ((n2 & 0x1F) == 31) {
            return -1;
        }
        int n3 = byArray[1] & 0xFF;
        if (n3 < 128) {
            return n3 + 2;
        }
        if (n3 == 128) {
            return -1;
        }
        if ((n3 &= 0x7F) < 1 || n3 > 4) {
            return -1;
        }
        int n4 = 2;
        int n5 = 0;
        while (n3-- > 0) {
            n5 <<= 8;
            n5 |= byArray[n4++] & 0xFF;
        }
        return n5 + n4;
    }

    public ASN1Object getComponentAt(int n2) throws CodingException {
        ASN1Object aSN1Object = this.toASN1Object();
        return aSN1Object.getComponentAt(n2);
    }

    public int countComponents() throws CodingException {
        ASN1Object aSN1Object = this.toASN1Object();
        return aSN1Object.countComponents();
    }

    private static int a(byte[] byArray, int n2, int[] nArray) throws CodingException {
        int n3;
        if ((n3 = byArray[n2++] & 0xFF) <= 127) {
            nArray[0] = n2;
            return n3;
        }
        if (n3 == 128) {
            nArray[0] = n2;
            int n4 = n2;
            try {
                while (true) {
                    if (byArray[n4] != 0) {
                        ++n4;
                        continue;
                    }
                    if (byArray[n4 + 1] == 0) {
                        return n4 - n2;
                    }
                    ++n4;
                }
            }
            catch (Exception exception) {
                throw new CodingException("Error decoding ASN1 indefinite format: " + exception.toString());
            }
        }
        if ((n3 &= 0x7F) > 4) {
            throw new CodingException("Too large ASN.1 object");
        }
        int n5 = 0;
        while (--n3 >= 0) {
            n5 = n5 << 8 | byArray[n2++] & 0xFF;
        }
        nArray[0] = n2;
        return n5;
    }

    public byte[] getFirstObject() throws CodingException {
        byte[] byArray = this.toByteArray();
        if (byArray == null) {
            throw new CodingException("Cannot parse data from a null object!");
        }
        int n2 = 0;
        if (byArray[n2++] != 48) {
            throw new CodingException("getFirstObject: No SEQUENCE!");
        }
        int[] nArray = new int[1];
        ASN1.a(byArray, n2, nArray);
        n2 = nArray[0];
        if (byArray[n2] != 48) {
            throw new CodingException("getFirstObject: No SEQUENCE in a SEQUENCE!");
        }
        int n3 = ASN1.a(byArray, n2 + 1, nArray);
        byte[] byArray2 = new byte[n3 + nArray[0] - n2];
        System.arraycopy(byArray, n2, byArray2, 0, n3 + nArray[0] - n2);
        return byArray2;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }

    public int getFormat() {
        return this.d;
    }

    public String toString() {
        return ASN1.a(this.toASN1Object(), "");
    }

    public static String print(ASN1Object aSN1Object) {
        return ASN1.a(aSN1Object, "");
    }

    private static String a(ASN1Object aSN1Object, String string) {
        string = string.concat("  ");
        if (aSN1Object == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(aSN1Object.toString());
        stringBuffer.append("\n");
        if (aSN1Object instanceof ConstructedType) {
            try {
                for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                    stringBuffer.append(string);
                    stringBuffer.append(ASN1.a(aSN1Object.getComponentAt(i2), string));
                }
            }
            catch (CodingException codingException) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    public byte[] toByteArray() {
        return this.toByteArray(false);
    }

    public byte[] toByteArray(boolean bl) {
        if (this.c == null || this.c[0] == 0) {
            if (this.b == null) {
                return null;
            }
            this.c = DerCoder.encode(this.b);
        }
        byte[] byArray = this.c;
        if (bl) {
            byArray = (byte[])byArray.clone();
        }
        return byArray;
    }

    public ASN1Object toASN1Object() {
        try {
            if (this.b == null) {
                if (this.c == null) {
                    throw new NullPointerException("ASN1 array not set");
                }
                this.b = DerCoder.decode(this.c);
            }
            return this.b;
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
    }

    public void clearASN1Object() {
        this.toByteArray();
        this.b = null;
    }

    public void clearByteArray() {
        this.toASN1Object();
        this.c = null;
    }

    public Object clone() {
        ASN1 aSN1 = null;
        try {
            aSN1 = (ASN1)super.clone();
            if (this.b != null) {
                aSN1.b = (ASN1Object)this.b.clone();
            }
            if (this.c != null) {
                aSN1.c = (byte[])this.c.clone();
            }
            aSN1.d = this.d;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return aSN1;
    }

    public byte[] fingerprint() {
        Md5 md5 = new Md5();
        md5.update(this.toByteArray());
        return md5.digest();
    }
}

